/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public abstract class AbstractAutoProxyCreator
extends ProxyConfig
implements BeanPostProcessor,
BeanFactoryAware,
Ordered {
    protected static final Object[] DO_NOT_PROXY = null;
    protected static final Object[] PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS = new Object[0];
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private String[] interceptorNames = new String[0];
    private boolean applyCommonInterceptorsFirst = true;
    private List customTargetSourceCreators = Collections.EMPTY_LIST;
    private BeanFactory owningBeanFactory;
    static /* synthetic */ Class class$org$springframework$aop$Advisor;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInterceptor;
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setCustomTargetSourceCreators(List targetSourceCreators) {
        this.customTargetSourceCreators = targetSourceCreators;
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setApplyCommonInterceptorsFirst(boolean applyCommonInterceptorsFirst) {
        this.applyCommonInterceptorsFirst = applyCommonInterceptorsFirst;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.owningBeanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.owningBeanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isInfrastructureClass(bean, beanName) || this.shouldSkip(bean, beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Did not attempt to autoproxy infrastructure class [" + bean.getClass().getName() + "]"));
            }
            return bean;
        }
        TargetSource targetSource = this.getCustomTargetSource(bean, beanName);
        Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(bean, beanName, targetSource);
        if (specificInterceptors != DO_NOT_PROXY || targetSource != null) {
            if (targetSource == null) {
                targetSource = new SingletonTargetSource(bean);
            }
            Advisor[] commonInterceptors = this.resolveInterceptorNames();
            ArrayList<Object> allInterceptors = new ArrayList<Object>();
            if (specificInterceptors != null) {
                allInterceptors.addAll(Arrays.asList(specificInterceptors));
                if (commonInterceptors != null) {
                    if (this.applyCommonInterceptorsFirst) {
                        allInterceptors.addAll(0, Arrays.asList(commonInterceptors));
                    } else {
                        allInterceptors.addAll(Arrays.asList(commonInterceptors));
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                int nrOfCommonInterceptors = commonInterceptors != null ? commonInterceptors.length : 0;
                int nrOfSpecificInterceptors = specificInterceptors != null ? specificInterceptors.length : 0;
                this.logger.debug((Object)("Creating implicit proxy for bean '" + beanName + "' with " + nrOfCommonInterceptors + " common interceptors and " + nrOfSpecificInterceptors + " specific interceptors"));
            }
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.copyFrom(this);
            if (!this.isProxyTargetClass()) {
                Class[] targetsInterfaces = AopUtils.getAllInterfaces(bean);
                for (int i = 0; i < targetsInterfaces.length; ++i) {
                    proxyFactory.addInterface(targetsInterfaces[i]);
                }
            }
            Iterator it = allInterceptors.iterator();
            while (it.hasNext()) {
                Advisor advisor = this.advisorAdapterRegistry.wrap(it.next());
                proxyFactory.addAdvisor(advisor);
            }
            proxyFactory.setTargetSource(targetSource);
            this.customizeProxyFactory(bean, proxyFactory);
            return proxyFactory.getProxy();
        }
        return bean;
    }

    protected void customizeProxyFactory(Object bean, ProxyFactory proxyFactory) {
    }

    private Advisor[] resolveInterceptorNames() {
        Advisor[] advisors = new Advisor[this.interceptorNames.length];
        for (int i = 0; i < this.interceptorNames.length; ++i) {
            Object next = this.owningBeanFactory.getBean(this.interceptorNames[i]);
            advisors[i] = this.advisorAdapterRegistry.wrap(next);
        }
        return advisors;
    }

    protected boolean isInfrastructureClass(Object bean, String beanName) {
        return (class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = AbstractAutoProxyCreator.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor).isAssignableFrom(bean.getClass()) || (class$org$aopalliance$intercept$MethodInterceptor == null ? (class$org$aopalliance$intercept$MethodInterceptor = AbstractAutoProxyCreator.class$("org.aopalliance.intercept.MethodInterceptor")) : class$org$aopalliance$intercept$MethodInterceptor).isAssignableFrom(bean.getClass()) || (class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator = AbstractAutoProxyCreator.class$("org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator).isAssignableFrom(bean.getClass());
    }

    protected boolean shouldSkip(Object bean, String beanName) {
        return false;
    }

    protected TargetSource getCustomTargetSource(Object bean, String beanName) {
        if (this.owningBeanFactory != null && this.owningBeanFactory.containsBean(beanName) && !this.owningBeanFactory.isSingleton(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Checking for custom TargetSource for bean with beanName '" + beanName + "'"));
            }
            for (int i = 0; i < this.customTargetSourceCreators.size(); ++i) {
                TargetSourceCreator tsc = (TargetSourceCreator)this.customTargetSourceCreators.get(i);
                TargetSource ts = tsc.getTargetSource(bean, beanName, this.owningBeanFactory);
                if (ts == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("TargetSourceCreator [" + tsc + " found custom TargetSource for bean with beanName '" + beanName + "'"));
                }
                return ts;
            }
        }
        return null;
    }

    protected abstract Object[] getAdvicesAndAdvisorsForBean(Object var1, String var2, TargetSource var3) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

