/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.AspectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements ClassFilter,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String[] patterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        this.initPatternRepresentation(patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    public final boolean matches(Method m, Class targetClass) {
        String patt = m.getDeclaringClass().getName() + "." + m.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            boolean matched = this.matches(patt, i);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public final ClassFilter getClassFilter() {
        return this;
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new AspectException("Failed to deserialize AOP regular expression pointcut: Check that Spring AOP libraries are available on the client side", (Throwable)ex);
        }
        this.logger = LogFactory.getLog(this.getClass());
        try {
            this.initPatternRepresentation(this.patterns);
        }
        catch (Throwable ex) {
            throw new AspectException("Failed to deserialize AOP regular expression pointcut: Check that the necessary regular expression libraries are available on the client side", ex);
        }
    }
}

