/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.HashMapCachingAdvisorChainFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.util.StringUtils;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    private transient List listeners = new LinkedList();
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    transient AdvisorChainFactory advisorChainFactory;
    private List advisors = new LinkedList();
    private Advisor[] advisorArray = new Advisor[0];
    private Set interfaces = new HashSet();
    private transient boolean isActive;
    static /* synthetic */ Class class$org$springframework$aop$framework$AdvisedSupport;

    public AdvisedSupport() {
        this.initDefaultAdvisorChainFactory();
    }

    public AdvisedSupport(Class[] interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    private void initDefaultAdvisorChainFactory() {
        this.setAdvisorChainFactory(new HashMapCachingAdvisorChainFactory());
    }

    public void addListener(AdvisedSupportListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    public void setTargetSource(TargetSource targetSource) {
        if (this.isActive() && this.getOptimize()) {
            throw new AopConfigException("Can't change target with an optimized CGLIB proxy: it has its own target");
        }
        this.targetSource = targetSource;
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        this.advisorChainFactory = advisorChainFactory;
        this.addListener(advisorChainFactory);
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyFrom(other);
        this.targetSource = other.targetSource;
        this.setInterfaces(other.interfaces.toArray(new Class[other.interfaces.size()]));
        this.advisors = new LinkedList();
        for (int i = 0; i < other.advisors.size(); ++i) {
            Advisor advice = (Advisor)other.advisors.get(i);
            this.addAdvisor(advice);
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces.clear();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addInterface(interfaces[i]);
        }
    }

    public void addInterface(Class newInterface) {
        this.interfaces.add(newInterface);
        this.adviceChanged();
        this.logger.debug((Object)("Added new aspect interface: " + newInterface));
    }

    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    public void addInterceptor(Interceptor interceptor) throws AopConfigException {
        this.addAdvice((Advice)interceptor);
    }

    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors != null ? this.advisors.size() : 0;
        this.addAdvice(pos, advice);
    }

    public boolean isInterfaceProxied(Class intf) {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class proxyIntf = (Class)it.next();
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    public void addInterceptor(int pos, Interceptor interceptor) throws AopConfigException {
        this.addAdvice(pos, (Advice)interceptor);
    }

    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        if (advice instanceof Interceptor) {
            if (!(advice instanceof MethodInterceptor)) {
                throw new AopConfigException(this.getClass().getName() + " only handles MethodInterceptors");
            }
            if (advice instanceof IntroductionInterceptor) {
                throw new AopConfigException("IntroductionInterceptors may only be added as part of IntroductionAdvice");
            }
        }
        this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
    }

    public final boolean removeInterceptor(Interceptor interceptor) throws AopConfigException {
        return this.removeAdvice((Advice)interceptor);
    }

    public final boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void addAfterReturningAdvice(AfterReturningAdvice ara) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(Pointcut.TRUE, ara));
    }

    public void addBeforeAdvice(MethodBeforeAdvice ba) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(Pointcut.TRUE, ba));
    }

    public void addThrowsAdvice(ThrowsAdvice throwsAdvice) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(throwsAdvice));
    }

    public int indexOf(Interceptor interceptor) {
        return this.indexOf((Advice)interceptor);
    }

    public int indexOf(Advice advice) {
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Advisor advisor) {
        return this.advisors.indexOf(advisor);
    }

    public final boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void removeAdvisor(int index) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: config is frozen");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: " + "Only have " + this.advisors.size() + " advisors");
        }
        Advisor advisor = (Advisor)this.advisors.get(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (int j = 0; j < ia.getInterfaces().length; ++j) {
                this.removeInterface(ia.getInterfaces()[j]);
            }
        }
        this.advisors.remove(index);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    private void addAdvisorInternal(int pos, Advisor advice) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: config is frozen");
        }
        this.advisors.add(pos, advice);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    public void addAdvisor(int pos, IntroductionAdvisor advisor) throws AopConfigException {
        advisor.validateInterfaces();
        for (int i = 0; i < advisor.getInterfaces().length; ++i) {
            this.addInterface(advisor.getInterfaces()[i]);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.addAdvisor(pos, (IntroductionAdvisor)advisor);
        } else {
            this.addAdvisorInternal(pos, advisor);
        }
    }

    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    private void updateAdvisorArray() {
        this.advisorArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    public final Advisor[] getAdvisors() {
        return this.advisorArray;
    }

    public final boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        int index = this.indexOf(a);
        if (index == -1 || b == null) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public final boolean interceptorIncluded(Interceptor mi) {
        return this.adviceIncluded((Advice)mi);
    }

    public final boolean adviceIncluded(Advice advice) {
        if (this.advisors.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return true;
        }
        return false;
    }

    public final int countInterceptorsOfType(Class interceptorClass) {
        return this.countAdvicesOfType(interceptorClass);
    }

    public final int countAdvicesOfType(Class interceptorClass) {
        if (this.advisors.size() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (!interceptorClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            ++count;
        }
        return count;
    }

    private synchronized void adviceChanged() {
        if (this.isActive) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((AdvisedSupportListener)this.listeners.get(i)).adviceChanged(this);
            }
        }
    }

    private void activate() {
        this.isActive = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((AdvisedSupportListener)this.listeners.get(i)).activated(this);
        }
    }

    protected synchronized AopProxy createAopProxy() {
        if (!this.isActive) {
            this.activate();
        }
        return this.getAopProxyFactory().createAopProxy(this);
    }

    protected final boolean isActive() {
        return this.isActive;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.logger.info((Object)("Disconnecting AdvisedSupport " + this));
        AdvisedSupport copy = this;
        if (this.getClass() != (class$org$springframework$aop$framework$AdvisedSupport == null ? (class$org$springframework$aop$framework$AdvisedSupport = AdvisedSupport.class$("org.springframework.aop.framework.AdvisedSupport")) : class$org$springframework$aop$framework$AdvisedSupport)) {
            copy = new AdvisedSupport();
            copy.copyConfigurationFrom(this);
        }
        return copy;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.logger = LogFactory.getLog(this.getClass());
        this.isActive = true;
        this.listeners = new LinkedList();
        this.initDefaultAdvisorChainFactory();
        return this;
    }

    public String toProxyConfigString() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append(this.interfaces.size()).append(" interfaces=[");
        int i = 0;
        Iterator itr = this.interfaces.iterator();
        while (itr.hasNext()) {
            Class intf = (Class)itr.next();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(intf.getName());
        }
        sb.append("]; ");
        sb.append(this.advisors.size()).append(" advisors=[");
        sb.append(StringUtils.collectionToDelimitedString((Collection)this.advisors, (String)",", (String)"{", (String)"}")).append("]; ");
        sb.append("targetSource=[").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        sb.append("advisorChainFactory=").append(this.advisorChainFactory);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

