/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.beans.PropertyEditor;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.tags.BindStatus;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;

public class BindTag
extends RequestContextAwareTag {
    public static final String STATUS_VARIABLE_NAME = "status";
    private String path;
    private String property;
    private Errors errors;
    private PropertyEditor editor;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    protected final int doStartTagInternal() throws Exception {
        String resolvedPath = ExpressionEvaluationUtils.evaluateString((String)"path", (String)this.path, (PageContext)this.pageContext);
        String name = null;
        int dotPos = resolvedPath.indexOf(46);
        if (dotPos == -1) {
            name = resolvedPath;
            this.property = null;
        } else {
            name = resolvedPath.substring(0, dotPos);
            this.property = resolvedPath.substring(dotPos + 1);
        }
        this.errors = this.getRequestContext().getErrors(name, false);
        if (this.errors == null) {
            throw new JspTagException("Could not find Errors instance for bean '" + name + "' in request: " + "add the Errors model to your ModelAndView via errors.getModel()");
        }
        List fes = null;
        Object value = null;
        if (this.property != null) {
            if ("*".equals(this.property)) {
                fes = this.errors.getAllErrors();
            } else if (this.property.endsWith("*")) {
                fes = this.errors.getFieldErrors(this.property);
            } else {
                fes = this.errors.getFieldErrors(this.property);
                value = this.errors.getFieldValue(this.property);
                if (this.errors instanceof BindException) {
                    this.editor = ((BindException)this.errors).getCustomEditor(this.property);
                } else {
                    this.logger.warn((Object)("Cannot not expose custom property editor because Errors instance [" + this.errors + "] is not of type BindException"));
                }
                if (this.isHtmlEscape() && value instanceof String) {
                    value = HtmlUtils.htmlEscape((String)((String)value));
                }
            }
        } else {
            fes = this.errors.getGlobalErrors();
        }
        BindStatus status = new BindStatus(this.property, value, this.getErrorCodes(fes), this.getErrorMessages(fes));
        this.pageContext.setAttribute(STATUS_VARIABLE_NAME, (Object)status);
        return 1;
    }

    private String[] getErrorCodes(List fes) {
        String[] codes = new String[fes.size()];
        for (int i = 0; i < fes.size(); ++i) {
            ObjectError error = (ObjectError)fes.get(i);
            codes[i] = error.getCode();
        }
        return codes;
    }

    private String[] getErrorMessages(List fes) throws NoSuchMessageException, JspException {
        String[] messages = new String[fes.size()];
        for (int i = 0; i < fes.size(); ++i) {
            ObjectError error = (ObjectError)fes.get(i);
            messages[i] = this.getRequestContext().getMessage((MessageSourceResolvable)error, this.isHtmlEscape());
        }
        return messages;
    }

    public final String getProperty() {
        return this.property;
    }

    public final Errors getErrors() {
        return this.errors;
    }

    public final PropertyEditor getEditor() {
        return this.editor;
    }

    public void doFinally() {
        super.doFinally();
        this.path = null;
        this.property = null;
        this.errors = null;
        this.editor = null;
    }
}

