/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HttpServletBean;

public class ResourceServlet
extends HttpServletBean {
    public static final String RESOURCE_PARAM_NAME = "resource";
    private String defaultUrl;
    private String allowedResources;
    private String contentType;
    private boolean applyLastModified = false;
    private long startupTime;

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public void setAllowedResources(String allowedResources) {
        this.allowedResources = allowedResources;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setApplyLastModified(boolean applyLastModified) {
        this.applyLastModified = applyLastModified;
    }

    protected void initServletBean() {
        this.startupTime = System.currentTimeMillis();
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            String resourceUrl = this.determineResourceUrl(request);
            if (resourceUrl == null) {
                throw new ServletException("No target resource URL found for request");
            }
            if (this.allowedResources != null && !PathMatcher.match((String)this.allowedResources, (String)resourceUrl)) {
                throw new ServletException("Resource [" + resourceUrl + "] does not match allowed pattern [" + this.allowedResources + "]");
            }
            try {
                this.doInclude(request, response, resourceUrl);
            }
            catch (ServletException ex) {
                this.logger.warn((Object)("Failed to include content of resource [" + resourceUrl + "]"), (Throwable)ex);
                if (!this.includeDefaultUrl(request, response)) {
                    throw ex;
                }
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Failed to include content of resource [" + resourceUrl + "]"), (Throwable)ex);
                if (this.includeDefaultUrl(request, response)) break block6;
                throw ex;
            }
        }
    }

    protected final long getLastModified(HttpServletRequest request) {
        String resourceUrl;
        if (this.applyLastModified && (resourceUrl = this.determineResourceUrl(request)) != null) {
            try {
                File resource = new ServletContextResource(this.getServletContext(), resourceUrl).getFile();
                long lastModifiedTime = resource.lastModified();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Last-modified timestamp of resource file [" + resource.getAbsolutePath() + "] is " + lastModifiedTime));
                }
                return lastModifiedTime > this.startupTime ? lastModifiedTime : this.startupTime;
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Couldn't retrieve lastModified timestamp of resource [" + resourceUrl + "] - returning ResourceServlet startup time"));
                return this.startupTime;
            }
        }
        return -1L;
    }

    protected String determineResourceUrl(HttpServletRequest request) {
        return request.getParameter(RESOURCE_PARAM_NAME);
    }

    private boolean includeDefaultUrl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.defaultUrl == null) {
            return false;
        }
        this.doInclude(request, response, this.defaultUrl);
        return true;
    }

    private void doInclude(HttpServletRequest request, HttpServletResponse response, String resourceUrl) throws ServletException, IOException {
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        RequestDispatcher rd = request.getRequestDispatcher(resourceUrl);
        rd.include((ServletRequest)request, (ServletResponse)response);
        this.logger.debug((Object)("Included resource [" + resourceUrl + "]"));
    }
}

