/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;

public abstract class AbstractJndiLocator
implements InitializingBean {
    public static String CONTAINER_PREFIX = "java:comp/env/";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private String jndiName;
    private boolean resourceRef = false;

    public AbstractJndiLocator() {
    }

    public AbstractJndiLocator(String jndiName) throws NamingException, IllegalArgumentException {
        this.setJndiName(jndiName);
        this.afterPropertiesSet();
    }

    public final void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public final JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public final void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public final Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public final void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public final boolean isResourceRef() {
        return this.resourceRef;
    }

    public final void afterPropertiesSet() throws NamingException, IllegalArgumentException {
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new IllegalArgumentException("Property 'jndiName' must be set on " + this.getClass().getName());
        }
        if (this.resourceRef && !this.jndiName.startsWith(CONTAINER_PREFIX) && this.jndiName.indexOf(58) == -1) {
            this.jndiName = CONTAINER_PREFIX + this.jndiName;
        }
        this.lookup();
    }

    protected final void lookup() throws NamingException {
        Object jndiObject = this.jndiTemplate.lookup(this.jndiName);
        this.logger.debug((Object)("Successfully looked up object with jndiName '" + this.jndiName + "': value=[" + jndiObject + "]"));
        this.located(jndiObject);
    }

    protected abstract void located(Object var1);
}

