/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.xml.sax.helpers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class AbstractXmlReader
implements XMLReader {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private final Map features = new HashMap();
    private final Map properties = new HashMap();

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("value contentHandler is null");
        }
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        if (dtdHandler == null) {
            throw new NullPointerException("value dtdHandler is null");
        }
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("value errorHandler is null");
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            throw new NullPointerException("value entityResolver is null");
        }
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean b = (Boolean)this.features.get(name);
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.properties.get(name);
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    public abstract void parse(InputSource var1) throws SAXException, IOException;
}

