/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util.pipe;

import de.speexx.util.pipe.AsyncEvent;
import de.speexx.util.pipe.AsyncExceptionListener;
import de.speexx.util.pipe.AsyncMonitorListener;
import de.speexx.util.pipe.AsyncReadyListener;
import de.speexx.util.pipe.DispatchObject;
import de.speexx.util.pipe.Dispatchable;
import de.speexx.util.pipe.Filter;
import de.speexx.util.pipe.Processor;
import de.speexx.util.pipe.Receivable;
import de.speexx.util.pipe.Receiver;
import java.util.TooManyListenersException;

public class SimpleReceiver
extends Receiver
implements Receivable {
    protected final Filter filter;
    protected final Processor processor;
    protected Dispatchable nextDispatchable = null;
    protected AsyncExceptionListener asyncExceptionListener = null;
    protected AsyncMonitorListener asyncMonitorListener = null;
    protected AsyncReadyListener asyncReadyListener = null;

    public SimpleReceiver(Filter filter, Processor processor) {
        this(filter, processor, null);
    }

    public SimpleReceiver(Filter filter, Processor processor, String name) {
        super(name);
        if (filter == null || processor == null) {
            throw new NullPointerException(filter != null ? "missing processor" : "missing filter");
        }
        this.filter = filter;
        this.processor = processor;
    }

    public boolean filterDispatchObject(DispatchObject dispatchObject) {
        try {
            if (this.filter.filter(dispatchObject.getFilterObject())) {
                this.processDispatchObject(dispatchObject);
                return true;
            }
        }
        catch (Throwable t) {
            this.fireAsyncExceptionEvent(new AsyncEvent(dispatchObject, this, (Object)t));
        }
        return false;
    }

    protected void processDispatchObject(DispatchObject de) {
        try {
            this.processor.process(de);
            this.nextDispatcher(de);
        }
        catch (Throwable t) {
            this.fireAsyncExceptionEvent(new AsyncEvent(de, this, (Object)t));
        }
    }

    private void nextDispatcher(DispatchObject de) {
        Dispatchable tmpDispatchable = this.getDispatcher();
        if (tmpDispatchable != null) {
            tmpDispatchable.dispatch(de);
        } else {
            this.fireAsyncReadyEvent(new AsyncEvent(de, this, null));
        }
    }

    public Dispatchable setDispatcher(Dispatchable newDispatchable) {
        Dispatchable tmpDispatchable = this.getDispatcher();
        this.nextDispatchable = newDispatchable;
        return tmpDispatchable;
    }

    public Dispatchable getDispatcher() {
        return this.nextDispatchable;
    }

    public final AsyncExceptionListener getAsyncExceptionListener() {
        return this.asyncExceptionListener;
    }

    public final void addAsyncExceptionListener(AsyncExceptionListener ael) throws TooManyListenersException {
        if (this.asyncExceptionListener != null && ael != null) {
            throw new TooManyListenersException();
        }
        this.asyncExceptionListener = ael;
    }

    protected void fireAsyncExceptionEvent(AsyncEvent ae) {
        AsyncExceptionListener ael = this.asyncExceptionListener;
        if (ael != null) {
            ael.onException(ae);
        }
    }

    public final AsyncReadyListener getAsyncReadyListener() {
        return this.asyncReadyListener;
    }

    public final void addAsyncReadyListener(AsyncReadyListener arl) throws TooManyListenersException {
        if (this.asyncReadyListener != null && arl != null) {
            throw new TooManyListenersException();
        }
        this.asyncReadyListener = arl;
    }

    protected void fireAsyncReadyEvent(AsyncEvent ae) {
        AsyncReadyListener arl = this.asyncReadyListener;
        if (arl != null) {
            arl.ready(ae);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Filter getFilter() {
        return this.filter;
    }
}

