/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util.pipe;

import de.speexx.util.pipe.AsyncEvent;
import de.speexx.util.pipe.AsyncExceptionListener;
import de.speexx.util.pipe.DispatchObject;
import de.speexx.util.pipe.Dispatchable;
import de.speexx.util.pipe.Dispatcher;
import de.speexx.util.pipe.Receivable;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;

public class SimpleDispatcher
extends Dispatcher
implements Dispatchable {
    protected final List receiverList = new ArrayList();
    protected AsyncExceptionListener asyncExceptionListener = null;

    public SimpleDispatcher() {
        this(null);
    }

    public SimpleDispatcher(String name) {
        super(name);
    }

    public void dispatch(DispatchObject dispatchObject) {
        if (dispatchObject != null) {
            Object[] receiver = this.receiverList.toArray();
            for (int i = 0; i < receiver.length; ++i) {
                Receivable dc = (Receivable)receiver[i];
                if (!dc.filterDispatchObject(dispatchObject)) continue;
                return;
            }
            this.fireAsyncExceptionEvent(new AsyncEvent(dispatchObject, this, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(Receivable newReceivable) {
        if (newReceivable != null) {
            List list = this.receiverList;
            synchronized (list) {
                if (!this.receiverList.contains(newReceivable)) {
                    this.receiverList.add(newReceivable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeReceiver(Receivable oldReceivable) {
        if (oldReceivable != null) {
            List list = this.receiverList;
            synchronized (list) {
                int i = this.receiverList.indexOf(oldReceivable);
                if (i < 0) {
                    this.receiverList.remove(i);
                }
            }
        }
    }

    public final AsyncExceptionListener getAsyncExceptionListener() {
        return this.asyncExceptionListener;
    }

    public final void addAsyncExceptionListener(AsyncExceptionListener ael) throws TooManyListenersException {
        if (this.asyncExceptionListener != null && ael != null) {
            throw new TooManyListenersException();
        }
        this.asyncExceptionListener = ael;
    }

    protected void fireAsyncExceptionEvent(AsyncEvent ae) {
        AsyncExceptionListener ael = this.asyncExceptionListener;
        if (ael != null) {
            ael.onException(ae);
        }
    }
}

