/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util.pipe;

import de.speexx.util.pipe.AsyncEvent;
import de.speexx.util.pipe.DispatchObject;
import de.speexx.util.pipe.Receivable;
import de.speexx.util.pipe.SimpleDispatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class RoundRobinDispatcher
extends SimpleDispatcher {
    private ListIterator globalIterator;
    private final Object globalIteratorMutex;
    private final Set removableReceivers;
    private int maxSize;

    public RoundRobinDispatcher() {
        this.globalIterator = this.receiverList.listIterator();
        this.globalIteratorMutex = new Object();
        this.removableReceivers = Collections.synchronizedSet(new HashSet());
    }

    public RoundRobinDispatcher(String name) {
        super(name);
        this.globalIterator = this.receiverList.listIterator();
        this.globalIteratorMutex = new Object();
        this.removableReceivers = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkForRemove(Receivable receiver) {
        if (this.removableReceivers.contains(receiver)) {
            Object object = this.globalIteratorMutex;
            synchronized (object) {
                this.globalIterator.remove();
            }
            this.removableReceivers.remove(receiver);
            --this.maxSize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(DispatchObject dispatchObject) {
        this.maxSize = this.receiverList.size();
        int counter = 0;
        while (true) {
            if (this.globalIterator.hasNext()) {
                Receivable dc = (Receivable)this.globalIterator.next();
                if (this.checkForRemove(dc)) continue;
                if (dc.filterDispatchObject(dispatchObject)) break;
                if (counter++ <= this.maxSize) continue;
                AsyncEvent event = new AsyncEvent(dispatchObject, this, null);
                this.fireAsyncExceptionEvent(event);
                break;
            }
            Object object = this.globalIteratorMutex;
            synchronized (object) {
                this.globalIterator = this.receiverList.listIterator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(Receivable newReceivable) {
        Object object = this.globalIteratorMutex;
        synchronized (object) {
            this.globalIterator.add(newReceivable);
            ++this.maxSize;
        }
    }

    public void removeReceiver(Receivable oldReceivable) {
        this.removableReceivers.add(oldReceivable);
    }
}

