/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util;

import de.speexx.util.Fifo;
import de.speexx.util.FifoIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class Queue
implements Cloneable,
Serializable,
Collection,
Fifo {
    private static final long serialVersionUID = 3617293424089445170L;
    private final LinkedList elements;

    public Queue() {
        this.elements = new LinkedList();
    }

    public Queue(Collection c) {
        this.elements = new LinkedList(c);
    }

    public boolean add(Object o) {
        return this.enqueue(o);
    }

    public boolean enqueue(Object o) {
        this.elements.addLast(o);
        return true;
    }

    public Object dequeue() {
        Object o = this.elements.getFirst();
        this.elements.removeFirst();
        return o;
    }

    public boolean addAll(Collection c) {
        return this.elements.addAll(c);
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.elements.containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Queue queue = (Queue)o;
        return this.elements.equals(queue.elements);
    }

    public String toString() {
        return "Queue[size=" + this.size() + ']';
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.elements.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.elements.retainAll(c);
    }

    public int size() {
        return this.elements.size();
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] oa) {
        return this.elements.toArray(oa);
    }

    public FifoIterator fifoIterator() {
        ListIterator li = this.elements.listIterator();
        return new SimpleFifoIterator(li);
    }

    private static final class SimpleFifoIterator
    implements FifoIterator {
        public final ListIterator listIterator;

        public SimpleFifoIterator(ListIterator listIterator) {
            this.listIterator = listIterator;
        }

        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        public Object next() {
            return this.listIterator.next();
        }

        public void remove() {
            this.listIterator.remove();
        }

        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        public Object previous() {
            return this.listIterator.previous();
        }
    }
}

