/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class LocaleManager {
    private static final Map MANAGER = new HashMap();
    private final ResourceBundle resource;
    private final String packageName;

    public static synchronized LocaleManager getManager(String packageName) {
        LocaleManager manager = (LocaleManager)MANAGER.get(packageName.intern());
        if (manager == null) {
            manager = new LocaleManager(packageName.intern());
            MANAGER.put(packageName.intern(), manager);
        }
        return manager;
    }

    private LocaleManager(String packageName) {
        this.packageName = packageName;
        this.resource = ResourceBundle.getBundle(packageName + ".locales");
    }

    public String getString(String key) {
        if (key == null) {
            throw new NullPointerException("key is 'null'");
        }
        return this.resource.getString(key);
    }

    public String getString(String key, Object[] arguments) {
        if (arguments == null) {
            throw new NullPointerException();
        }
        Object[] notNullArguments = arguments;
        for (int i = 0; i < notNullArguments.length; ++i) {
            if (notNullArguments[i] != null) continue;
            if (notNullArguments == arguments) {
                notNullArguments = (Object[])notNullArguments.clone();
            }
            notNullArguments[i] = "null";
        }
        String value = this.getString(key);
        return MessageFormat.format(value, notNullArguments);
    }

    public String getString(String key, Object argument) {
        return this.getString(key, new Object[]{argument});
    }

    public String getString(String key, Object argument1, Object argument2) {
        return this.getString(key, new Object[]{argument1, argument2});
    }

    public String getString(String key, Object argument1, Object argument2, Object argument3) {
        return this.getString(key, new Object[]{argument1, argument2, argument3});
    }

    public String getString(String key, Object argument1, Object argument2, Object argument3, Object argument4) {
        return this.getString(key, new Object[]{argument1, argument2, argument3, argument4});
    }

    public String toString() {
        return "[LocaleManager for" + this.packageName + "]";
    }
}

