/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.thread;

public final class SynchronizedFloat
extends Number
implements Cloneable {
    private static final long serialVersionUID = 4050766000519590960L;
    private float value;

    public SynchronizedFloat() {
    }

    public SynchronizedFloat(float f) {
        this.value = f;
    }

    public SynchronizedFloat(Float f) {
        this.value = f.floatValue();
    }

    public SynchronizedFloat(String s) {
        this.value = Float.valueOf(s).floatValue();
    }

    public synchronized float getValue() {
        return this.value;
    }

    public synchronized void setValue(float f) {
        this.value = f;
    }

    public synchronized boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(((SynchronizedFloat)o).value);
    }

    public synchronized Object clone() {
        return new SynchronizedFloat(this.value);
    }

    public synchronized String toString() {
        return String.valueOf(this.value);
    }

    public synchronized int hashCode() {
        return (int)this.value;
    }

    public synchronized void add(float f) {
        this.value += f;
    }

    public synchronized void sub(float f) {
        this.value -= f;
    }

    public synchronized boolean isLessThan(float f) {
        return this.value < f;
    }

    public synchronized boolean isGreaterThan(float f) {
        return this.value > f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isLessThan(Number n) {
        Number number = n;
        synchronized (number) {
            return this.value < n.floatValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isGreaterThan(Number n) {
        Number number = n;
        synchronized (number) {
            return this.value > n.floatValue();
        }
    }

    public synchronized byte byteValue() {
        return (byte)this.value;
    }

    public synchronized short shortValue() {
        return (short)this.value;
    }

    public synchronized int intValue() {
        return (int)this.value;
    }

    public synchronized long longValue() {
        return (long)this.value;
    }

    public synchronized float floatValue() {
        return this.value;
    }

    public synchronized double doubleValue() {
        return this.value;
    }
}

