/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.thread;

import de.speexx.thread.Sync;

public class Countdown
implements Sync {
    private int countdownCounter;

    public Countdown(int initialPermits) {
        if (initialPermits < 1) {
            throw new IllegalArgumentException("illegal value: " + initialPermits);
        }
        this.countdownCounter = initialPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Countdown countdown = this;
        synchronized (countdown) {
            try {
                while (this.countdownCounter <= 0) {
                    this.wait();
                }
                --this.countdownCounter;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        this.notifyAll();
    }

    public boolean attempt(long millis) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Countdown countdown = this;
        synchronized (countdown) {
            if (this.countdownCounter > 0) {
                --this.countdownCounter;
                return true;
            }
            if (millis <= 0L) {
                return false;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = millis;
                do {
                    this.wait(waitTime);
                    if (this.countdownCounter <= 0) continue;
                    --this.countdownCounter;
                    return true;
                } while ((waitTime = millis - (System.currentTimeMillis() - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public int getFreeResource() {
        return this.countdownCounter;
    }

    public String toString() {
        return "freeResources=" + this.getFreeResource();
    }
}

