/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.reflect;

import de.speexx.reflect.ArrayTypeMatcher;
import de.speexx.reflect.DynamicException;
import de.speexx.reflect.ProxyFactory;
import de.speexx.util.GenericFactory;
import de.speexx.util.ParameterList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractGenericFactory
implements GenericFactory {
    private static final GenericFactory FACTORY = (GenericFactory)ProxyFactory.getInstance().createProxy(new AbstractGenericFactory(){});
    private static final boolean ACCESS = System.getProperty("de.speexx.util.access") != null;
    private static final ParameterList EMPTY_LIST = new ParameterList();
    private final ArrayTypeMatcher arrayMatcher = new ArrayTypeMatcher();

    public static final GenericFactory getInstance() {
        return FACTORY;
    }

    public final Object newInstance(String clazzName) throws DynamicException {
        try {
            return this.newInstance(this.getClass(clazzName));
        }
        catch (ClassNotFoundException ex) {
            throw new DynamicException(ex, ex.getMessage());
        }
    }

    public final Object newInstance(String clazzName, ClassLoader loader) throws DynamicException {
        try {
            return this.newInstance(Class.forName(clazzName, true, loader));
        }
        catch (ClassNotFoundException ex) {
            throw new DynamicException(ex, ex.getMessage());
        }
    }

    public final Object newInstance(Class clazz) throws DynamicException {
        Object o = null;
        o = this.newInstance(clazz, EMPTY_LIST);
        return o;
    }

    public final Object newInstance(String clazzName, ParameterList pl) throws DynamicException {
        try {
            return this.newInstance(this.getClass(clazzName), pl);
        }
        catch (ClassNotFoundException ex) {
            throw new DynamicException(ex, ex.getMessage());
        }
    }

    public final Object newInstance(String clazzName, ParameterList pl, ClassLoader loader) throws DynamicException {
        try {
            return this.newInstance(Class.forName(clazzName, true, loader), pl);
        }
        catch (ClassNotFoundException ex) {
            throw new DynamicException(ex, ex.getMessage());
        }
    }

    public final Object newInstance(Class clazz, ParameterList pl) throws DynamicException {
        try {
            try {
                return this.fastCreationStrategy(clazz, pl);
            }
            catch (Exception ex) {
                return this.slowCreationStrategy(clazz, pl);
            }
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final Class getClass(String clazzName) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (clazz == null) {
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException ex) {
                try {
                    clazz = Class.forName(clazzName, true, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException ex2) {
                    Thread t = Thread.currentThread();
                    ClassLoader loader = t.getContextClassLoader();
                    clazz = loader.loadClass(clazzName);
                }
            }
        }
        return clazz;
    }

    private final Object fastCreationStrategy(Class clazz, ParameterList pl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Class[] list = pl.getClassList();
            Constructor constructor = clazz.getDeclaredConstructor(list);
            if (ACCESS) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(pl.getObjectList());
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("NoSuchMethodException");
        }
        catch (SecurityException ex) {
            throw new IllegalAccessException("SecurityException");
        }
    }

    private final Object slowCreationStrategy(Class clazz, ParameterList pl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorList = clazz.getDeclaredConstructors();
        Class[] parameterTypes = pl.getClassList();
        for (int i = 0; i < constructorList.length; ++i) {
            Class[] argumentTypes = constructorList[i].getParameterTypes();
            if (!this.isMatching(parameterTypes, argumentTypes)) continue;
            if (ACCESS) {
                constructorList[i].setAccessible(true);
            }
            return constructorList[i].newInstance(pl.getObjectList());
        }
        throw new InstantiationException();
    }

    public final boolean isMatching(Class[] paramType, Class[] constType) {
        if (paramType != null && constType != null && paramType.length == constType.length) {
            for (int i = 0; i < paramType.length; ++i) {
                if (paramType[i] == null && constType[i].isPrimitive()) {
                    return false;
                }
                if (paramType[i] == null && !constType[i].isPrimitive()) continue;
                if (paramType[i].isPrimitive() && constType[i].isPrimitive()) {
                    if (paramType[i] == constType[i]) continue;
                    return false;
                }
                if (!paramType[i].isPrimitive() && !constType[i].isPrimitive()) {
                    if (paramType[i].isArray() && constType[i].isArray()) {
                        if (this.arrayMatcher.isMatching(paramType[i], constType[i])) continue;
                        return false;
                    }
                    if (!paramType[i].isArray() && !constType[i].isArray()) {
                        if (paramType[i].isInterface()) {
                            return false;
                        }
                        if (paramType[i] == constType[i] || constType[i].isAssignableFrom(paramType[i])) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

