/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import space.vectrix.ignite.util.BlackboardMap;

public final class Blackboard {
    private static final BlackboardMap BLACKBOARD = BlackboardMap.create();
    public static final @NotNull BlackboardMap.Key<Boolean> DEBUG = Blackboard.key("ignite.debug", Boolean.class, false);
    public static final @NotNull BlackboardMap.Key<String> GAME_LOCATOR = Blackboard.key("ignite.locator", String.class, "dummy");
    public static final @NotNull BlackboardMap.Key<Path> GAME_JAR = Blackboard.key("ignite.jar", Path.class, Paths.get("./server.jar", new String[0]));
    public static final @NotNull BlackboardMap.Key<String> GAME_TARGET = Blackboard.key("ignite.target", String.class, "org.bukkit.craftbukkit.Main");
    public static final @NotNull BlackboardMap.Key<Path> GAME_LIBRARIES = Blackboard.key("ignite.libraries", Path.class, Paths.get("./libraries", new String[0]));
    public static final @NotNull BlackboardMap.Key<Path> MODS_DIRECTORY = Blackboard.key("ignite.mods", Path.class, Paths.get("./mods", new String[0]));

    @NotNull
    public static <T> Optional<T> get(@NotNull BlackboardMap.Key<T> key) {
        return BLACKBOARD.get(key);
    }

    public static <T> @UnknownNullability T raw(@NotNull BlackboardMap.Key<T> key) {
        return BLACKBOARD.get(key).orElse(key.defaultValue());
    }

    public static <T> void compute(@NotNull BlackboardMap.Key<T> key, @NotNull Supplier<T> supplier) {
        BLACKBOARD.put(key, Blackboard.supplyOrNull(supplier));
    }

    public static <T> void put(@NotNull BlackboardMap.Key<T> key, @Nullable T value) {
        BLACKBOARD.put(key, value);
    }

    public static <T> @NotNull BlackboardMap.Key<T> key(@NotNull String key, @NotNull Class<? super T> type, @Nullable T defaultValue) {
        return BlackboardMap.Key.of(BLACKBOARD, key, type, defaultValue);
    }

    @Nullable
    private static <T> T supplyOrNull(@NotNull Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Blackboard() {
    }
}

