/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MD5Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=MD5Serializer.class)
public final class MD5 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("MD5"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;

    public MD5(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
    }

    public MD5(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public MD5(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MD5 t = (MD5)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3);
    }

    @NotNull
    public static MD5 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(MD5.getThreadLocalDigest(), inputStream, MD5::new);
    }

    @NotNull
    public static MD5 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(MD5.getThreadLocalDigest(), channel, MD5::new);
    }

    @NotNull
    public static MD5 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(MD5.getThreadLocalDigest(), path, MD5::new);
    }

    @NotNull
    public static MD5 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(MD5.getThreadLocalDigest(), data, off, len, MD5::new);
    }

    @NotNull
    public static MD5 of(byte @NotNull [] data) {
        return MD5.of(data, 0, data.length);
    }
}

