/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.mockserver.containers;

import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MockServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MockServerUtils.class);
    public static final String DEFAULT_VERSION = "latest";
    private static String cachedVersion;
    static final String MOCKSERVER_VERSION_SNAPSHOT_ALLOWED_KEY = "MOCKSERVER_VERSION_SNAPSHOT_ALLOWED";

    private MockServerUtils() {
    }

    public static String getClasspathMockserverVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        cachedVersion = MockServerUtils.determineClasspathMockserverVersion();
        return cachedVersion;
    }

    static synchronized String determineClasspathMockserverVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        HashSet<String> versions = new HashSet<String>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifestURL = manifests.nextElement();
                InputStream is = manifestURL.openStream();
                try {
                    Manifest manifest = new Manifest();
                    manifest.read(is);
                    String version = MockServerUtils.getMockserverVersionFromManifest(manifest);
                    if (version == null) continue;
                    versions.add(version);
                    LOG.info("Mockserver API version {} detected on classpath", (Object)version);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to determine Mockserver-Version from JAR Manifest", (Throwable)e);
        }
        if (versions.isEmpty()) {
            LOG.warn("Failed to determine Mockserver version from classpath - will use default version of {}", (Object)DEFAULT_VERSION);
            return DEFAULT_VERSION;
        }
        String foundVersion = (String)versions.stream().max(Comparator.naturalOrder()).orElseThrow();
        if (versions.size() > 1) {
            LOG.warn("Multiple versions of Mockserver API found on classpath - will select {}, but this may not be reliable", (Object)foundVersion);
        }
        if (foundVersion.endsWith("-SNAPSHOT") && !MockServerUtils.isSnapshotVersionAllowed()) {
            LOG.warn("Found version is a SNAPSHOT - will use default {}", (Object)DEFAULT_VERSION);
            return DEFAULT_VERSION;
        }
        return foundVersion;
    }

    static boolean isSnapshotVersionAllowed() {
        return Stream.of(System.getenv(MOCKSERVER_VERSION_SNAPSHOT_ALLOWED_KEY), System.getProperty(MOCKSERVER_VERSION_SNAPSHOT_ALLOWED_KEY)).filter(Objects::nonNull).anyMatch(s -> Boolean.parseBoolean(s) || "1".equals(s));
    }

    static String getMockserverVersionFromManifest(Manifest manifest) {
        String versuib = null;
        Attributes buildInfo = manifest.getAttributes("Mockserver-Info");
        if (buildInfo != null) {
            versuib = buildInfo.getValue("Version");
        }
        return versuib;
    }
}

