/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.model.SocketAddress;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class SocketAddressToJavaSerializer
implements ToJavaSerializer<SocketAddress> {
    @Override
    public String serialize(int numberOfSpacesToIndent, SocketAddress socketAddress) {
        StringBuilder output = new StringBuilder();
        if (socketAddress != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("new SocketAddress()");
            if (socketAddress.getHost() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHost(\"").append(socketAddress.getHost()).append("\")");
            }
            if (socketAddress.getPort() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withPort(").append(socketAddress.getPort()).append(')');
            }
            if (socketAddress.getScheme() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withScheme(SocketAddress.Scheme.").append(socketAddress.getScheme()).append(')');
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

