/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.event.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.lmax.disruptor.EventTranslator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import software.xdev.mockserver.matchers.HttpRequestMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.matchers.Times;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.time.EpochService;
import software.xdev.mockserver.util.StringUtils;
import software.xdev.mockserver.uuid.UUIDService;

public class EventEntry
implements EventTranslator<EventEntry> {
    private static final RequestDefinition[] EMPTY_REQUEST_DEFINITIONS = new RequestDefinition[0];
    private static final RequestDefinition[] DEFAULT_REQUESTS_DEFINITIONS = new RequestDefinition[]{HttpRequest.request()};
    private final DateFormat logDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private int hashCode;
    private String id;
    private String correlationId;
    private long epochTime = EpochService.currentTimeMillis();
    private String timestamp;
    private EventType type;
    private RequestDefinition[] httpRequests;
    private HttpResponse httpResponse;
    private HttpError httpError;
    private Expectation expectation;
    private String expectationId;
    private Exception exception;
    private Runnable consumer;
    private boolean deleted;

    private EventEntry setId(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    public String id() {
        if (this.id == null) {
            this.id = UUIDService.getUUID();
        }
        return this.id;
    }

    public void clear() {
        this.id = null;
        this.correlationId = null;
        this.epochTime = -1L;
        this.timestamp = null;
        this.type = null;
        this.httpRequests = null;
        this.httpResponse = null;
        this.httpError = null;
        this.expectation = null;
        this.expectationId = null;
        this.exception = null;
        this.consumer = null;
        this.deleted = false;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public EventEntry setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        this.timestamp = null;
        return this;
    }

    public String getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = this.logDateFormat.format(new Date(this.epochTime));
        }
        return this.timestamp;
    }

    public EventType getType() {
        return this.type;
    }

    public EventEntry setType(EventType type) {
        this.type = type;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public EventEntry setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @JsonIgnore
    public RequestDefinition[] getHttpRequests() {
        if (this.httpRequests == null) {
            return EMPTY_REQUEST_DEFINITIONS;
        }
        return this.httpRequests;
    }

    @JsonIgnore
    public boolean matches(HttpRequestMatcher matcher) {
        if (matcher == null) {
            return true;
        }
        if (this.httpRequests == null || this.httpRequests.length == 0) {
            return true;
        }
        RequestDefinition[] requestDefinitionArray = this.httpRequests;
        int n = requestDefinitionArray.length;
        for (int i = 0; i < n; ++i) {
            RequestDefinition httpRequest;
            RequestDefinition request;
            if (!matcher.matches(this.type == EventType.RECEIVED_REQUEST ? new MatchDifference(false, request) : null, request = (httpRequest = requestDefinitionArray[i]).cloneWithLogCorrelationId())) continue;
            return true;
        }
        return false;
    }

    public EventEntry setHttpRequests(RequestDefinition[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public RequestDefinition getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public EventEntry setHttpRequest(RequestDefinition httpRequest) {
        if (httpRequest != null) {
            if (StringUtils.isNotBlank((String)httpRequest.getLogCorrelationId())) {
                this.setCorrelationId(httpRequest.getLogCorrelationId());
            }
            this.httpRequests = new RequestDefinition[]{httpRequest};
        } else {
            this.httpRequests = DEFAULT_REQUESTS_DEFINITIONS;
        }
        return this;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public EventEntry setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public EventEntry setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public EventEntry setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public EventEntry setExpectation(RequestDefinition httpRequest, HttpResponse httpResponse) {
        this.expectation = new Expectation(httpRequest, Times.once(), TimeToLive.unlimited(), 0).thenRespond(httpResponse);
        return this;
    }

    public String getExpectationId() {
        return this.expectationId;
    }

    public EventEntry setExpectationId(String expectationId) {
        this.expectationId = expectationId;
        return this;
    }

    public boolean matchesAnyExpectationId(List<String> expectationIds) {
        if (expectationIds != null && StringUtils.isNotBlank((String)this.expectationId)) {
            return expectationIds.contains(this.expectationId);
        }
        return false;
    }

    public Exception getException() {
        return this.exception;
    }

    public EventEntry setException(Exception ex) {
        this.exception = ex;
        return this;
    }

    public Runnable getConsumer() {
        return this.consumer;
    }

    public EventEntry setConsumer(Runnable consumer) {
        this.consumer = consumer;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public EventEntry setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public EventEntry cloneAndClear() {
        EventEntry clone = this.clone();
        this.clear();
        return clone;
    }

    public EventEntry clone() {
        return new EventEntry().setId(this.id()).setType(this.getType()).setEpochTime(this.getEpochTime()).setCorrelationId(this.getCorrelationId()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setExpectationId(this.getExpectationId()).setException(this.getException()).setConsumer(this.getConsumer()).setDeleted(this.isDeleted());
    }

    public void translateTo(EventEntry event, long sequence) {
        event.setId(this.id()).setType(this.getType()).setEpochTime(this.getEpochTime()).setCorrelationId(this.getCorrelationId()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setExpectationId(this.getExpectationId()).setException(this.getException()).setConsumer(this.getConsumer()).setDeleted(this.isDeleted());
        this.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        EventEntry eventEntry = (EventEntry)o;
        return this.epochTime == eventEntry.epochTime && this.deleted == eventEntry.deleted && this.type == eventEntry.type && Objects.equals(this.httpResponse, eventEntry.httpResponse) && Objects.equals(this.httpError, eventEntry.httpError) && Objects.equals(this.expectation, eventEntry.expectation) && Objects.equals(this.expectationId, eventEntry.expectationId) && Objects.equals(this.consumer, eventEntry.consumer) && Arrays.equals(this.httpRequests, eventEntry.httpRequests);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(new Object[]{this.epochTime, this.deleted, this.type, this.httpResponse, this.httpError, this.expectation, this.expectationId, this.consumer});
            this.hashCode = result = 31 * result + Arrays.hashCode(this.httpRequests);
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper((boolean)true, (boolean)false, (JsonSerializer[])new JsonSerializer[0]).writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static enum EventType {
        RUNNABLE,
        RETRIEVED,
        RECEIVED_REQUEST,
        EXPECTATION_RESPONSE,
        NO_MATCH_RESPONSE,
        FORWARDED_REQUEST;

    }
}

