/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.matchers.Times;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class TimesToJavaSerializer
implements ToJavaSerializer<Times> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Times times) {
        StringBuilder output = new StringBuilder(20);
        if (times != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            if (times.isUnlimited()) {
                output.append("Times.unlimited()");
            } else if (times.getRemainingTimes() == 1) {
                output.append("Times.once()");
            } else {
                output.append("Times.exactly(").append(times.getRemainingTimes()).append(')');
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

