/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.collections;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.xdev.mockserver.collections.ImmutableEntry;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.RegexStringMatcher;
import software.xdev.mockserver.model.NottableString;

public final class SubSetMatcher {
    static boolean containsSubset(MatchDifference context, RegexStringMatcher regexStringMatcher, List<ImmutableEntry> subset, List<ImmutableEntry> superset) {
        boolean result = true;
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (ImmutableEntry subsetItem : subset) {
            Set<Integer> subsetItemMatchingIndexes = SubSetMatcher.matchesIndexes(context, regexStringMatcher, subsetItem, superset);
            boolean optionalAndNotPresent = subsetItem.isOptional() && !SubSetMatcher.containsKey(regexStringMatcher, subsetItem, superset);
            boolean nottedAndPresent = SubSetMatcher.nottedAndPresent(regexStringMatcher, subsetItem, superset);
            if (!optionalAndNotPresent && subsetItemMatchingIndexes.isEmpty() || nottedAndPresent) {
                result = false;
                break;
            }
            matchingIndexes.addAll(subsetItemMatchingIndexes);
        }
        if (result) {
            long subsetNonOptionalSize = subset.stream().filter(ImmutableEntry::isNotOptional).count();
            result = (long)matchingIndexes.size() >= subsetNonOptionalSize;
        }
        return result;
    }

    private static Set<Integer> matchesIndexes(MatchDifference context, RegexStringMatcher regexStringMatcher, ImmutableEntry matcherItem, List<ImmutableEntry> matchedList) {
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (int i = 0; i < matchedList.size(); ++i) {
            ImmutableEntry matchedItem = matchedList.get(i);
            boolean keyMatches = regexStringMatcher.matches(context, (NottableString)matcherItem.getKey(), (NottableString)matchedItem.getKey());
            boolean valueMatches = regexStringMatcher.matches(context, (NottableString)matcherItem.getValue(), (NottableString)matchedItem.getValue());
            if (!keyMatches || !valueMatches) continue;
            matchingIndexes.add(i);
        }
        return matchingIndexes;
    }

    private static boolean containsKey(RegexStringMatcher regexStringMatcher, ImmutableEntry matcherItem, List<ImmutableEntry> matchedList) {
        for (ImmutableEntry matchedItem : matchedList) {
            if (!regexStringMatcher.matches((NottableString)matcherItem.getKey(), (NottableString)matchedItem.getKey())) continue;
            return true;
        }
        return false;
    }

    private static boolean nottedAndPresent(RegexStringMatcher regexStringMatcher, ImmutableEntry matcherItem, List<ImmutableEntry> matchedList) {
        if (((NottableString)matcherItem.getKey()).isNot()) {
            NottableString unNottedMatcherItemKey = NottableString.string((String)((NottableString)matcherItem.getKey()).getValue());
            for (ImmutableEntry matchedItem : matchedList) {
                if (((NottableString)matchedItem.getKey()).isNot() || !regexStringMatcher.matches(unNottedMatcherItemKey, (NottableString)matchedItem.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private SubSetMatcher() {
    }
}

