/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.filters.HopByHopHeaderFilter;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.mock.action.http.HttpForwardActionResult;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;

public abstract class HttpForwardAction {
    private static final Logger LOG = LoggerFactory.getLogger(HttpForwardAction.class);
    private final NettyHttpClient httpClient;
    private final HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    HttpForwardAction(NettyHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpForwardActionResult sendRequest(HttpRequest request, InetSocketAddress remoteAddress, Function<HttpResponse, HttpResponse> overrideHttpResponse) {
        try {
            return new HttpForwardActionResult(request, this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(request).withProtocol(null), remoteAddress), overrideHttpResponse, remoteAddress);
        }
        catch (Exception e) {
            LOG.error("Exception forwarding request {}", (Object)request, (Object)e);
            return this.notFoundFuture(request);
        }
    }

    HttpForwardActionResult notFoundFuture(HttpRequest httpRequest) {
        CompletableFuture<HttpResponse> notFoundFuture = new CompletableFuture<HttpResponse>();
        notFoundFuture.complete(HttpResponse.notFoundResponse());
        return new HttpForwardActionResult(httpRequest, notFoundFuture, null);
    }
}

