/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.cors;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;

public class CORSHeaders {
    private static final String NULL_ORIGIN = "null";
    private final String corsAllowOrigin;
    private final String corsAllowHeaders;
    private final String corsAllowMethods;
    private final boolean corsAllowCredentials;
    private final String corsMaxAge;

    public CORSHeaders(String corsAllowOrigin, String corsAllowHeaders, String corsAllowMethods, boolean corsAllowCredentials, int corsMaxAge) {
        this(ServerConfiguration.configuration().corsAllowOrigin(corsAllowOrigin).corsAllowHeaders(corsAllowHeaders).corsAllowMethods(corsAllowMethods).corsAllowCredentials(corsAllowCredentials).corsMaxAgeInSeconds(corsMaxAge));
    }

    public CORSHeaders(ServerConfiguration configuration) {
        this.corsAllowOrigin = configuration.corsAllowOrigin();
        this.corsAllowHeaders = configuration.corsAllowHeaders();
        this.corsAllowMethods = configuration.corsAllowMethods();
        this.corsAllowCredentials = configuration.corsAllowCredentials();
        this.corsMaxAge = String.valueOf(configuration.corsMaxAgeInSeconds());
    }

    public static boolean isPreflightRequest(ServerConfiguration configuration, HttpRequest request) {
        boolean isPreflightRequest;
        Headers headers = request.getHeaders();
        boolean bl = isPreflightRequest = request.getMethod().getValue().equals(HttpMethod.OPTIONS.name()) && headers.containsEntry(HttpHeaderNames.ORIGIN.toString()) && headers.containsEntry(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD.toString());
        if (isPreflightRequest) {
            configuration.enableCORSForAPI(true);
        }
        return isPreflightRequest;
    }

    public void addCORSHeaders(HttpRequest request, HttpResponse response) {
        String origin = request.getFirstHeader(HttpHeaderNames.ORIGIN.toString());
        if (NULL_ORIGIN.equals(origin)) {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), NULL_ORIGIN);
        } else if (!origin.isEmpty() && this.corsAllowCredentials) {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), origin);
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), "true");
        } else {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), this.corsAllowOrigin);
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), String.valueOf(this.corsAllowCredentials));
        }
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), this.corsAllowMethods);
        Object allowHeaders = this.corsAllowHeaders;
        if (!request.getFirstHeader(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS.toString()).isEmpty()) {
            allowHeaders = (String)allowHeaders + ", " + request.getFirstHeader(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS.toString());
        }
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), (String)allowHeaders);
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS.toString(), (String)allowHeaders);
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_MAX_AGE.toString(), this.corsMaxAge);
    }

    private void setHeaderIfNotAlreadyExists(HttpResponse response, String name, String value) {
        if (response.getFirstHeader(name).isEmpty()) {
            response.withHeader(name, new String[]{value});
        }
    }
}

