/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.xdev.mockserver.collections.ImmutableEntry;
import software.xdev.mockserver.collections.SubSetMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.RegexStringMatcher;
import software.xdev.mockserver.model.KeyMatchStyle;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.NottableString;

public class NottableStringMultiMap {
    private final Map<NottableString, List<NottableString>> backingMap = new LinkedHashMap<NottableString, List<NottableString>>();
    private final RegexStringMatcher regexStringMatcher;
    private final KeyMatchStyle keyMatchStyle;

    public NottableStringMultiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, List<? extends KeyToMultiValue> entries) {
        this.keyMatchStyle = keyMatchStyle;
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (KeyToMultiValue keyToMultiValue : entries) {
            this.backingMap.put(keyToMultiValue.getName(), keyToMultiValue.getValues());
        }
    }

    public NottableStringMultiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, NottableString[] ... keyAndValues) {
        this.keyMatchStyle = keyMatchStyle;
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (NottableString[] keyAndValue : keyAndValues) {
            if (keyAndValue.length <= 0) continue;
            this.backingMap.put(keyAndValue[0], keyAndValue.length > 1 ? Arrays.asList(keyAndValue).subList(1, keyAndValue.length) : Collections.emptyList());
        }
    }

    public KeyMatchStyle getKeyMatchStyle() {
        return this.keyMatchStyle;
    }

    public boolean containsAll(MatchDifference context, NottableStringMultiMap subset) {
        switch (subset.keyMatchStyle) {
            case SUB_SET: {
                boolean isSubset = SubSetMatcher.containsSubset(context, this.regexStringMatcher, subset.entryList(), this.entryList());
                if (!isSubset && context != null) {
                    context.addDifference("multimap subset match failed subset:{}was not a subset of:{}", subset.entryList(), this.entryList());
                }
                return isSubset;
            }
            case MATCHING_KEY: {
                for (NottableString matcherKey : subset.backingMap.keySet()) {
                    List<NottableString> matchedValuesForKey = this.getAll(matcherKey);
                    if (matchedValuesForKey.isEmpty() && !matcherKey.isOptional()) {
                        if (context != null) {
                            context.addDifference("multimap subset match failed subset:{}did not have expected key:{}", subset, matcherKey);
                        }
                        return false;
                    }
                    List<NottableString> matcherValuesForKey = subset.getAll(matcherKey);
                    for (NottableString matchedValue : matchedValuesForKey) {
                        boolean matchesValue = false;
                        for (NottableString matcherValue : matcherValuesForKey) {
                            if (this.regexStringMatcher.matches(context, matcherValue, matchedValue)) {
                                matchesValue = true;
                                break;
                            }
                            if (context == null) continue;
                            context.addDifference("multimap matching key match failed for key:{}", matcherKey);
                        }
                        if (matchesValue) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean allKeysNotted() {
        if (!this.isEmpty()) {
            for (NottableString key : this.backingMap.keySet()) {
                if (key.isNot()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allKeysOptional() {
        if (!this.isEmpty()) {
            for (NottableString key : this.backingMap.keySet()) {
                if (key.isOptional()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    private List<NottableString> getAll(NottableString key) {
        if (!this.isEmpty()) {
            ArrayList<NottableString> values = new ArrayList<NottableString>();
            for (Map.Entry<NottableString, List<NottableString>> entry : this.backingMap.entrySet()) {
                if (!this.regexStringMatcher.matches(key, entry.getKey())) continue;
                values.addAll((Collection<NottableString>)entry.getValue());
            }
            return values;
        }
        return Collections.emptyList();
    }

    private List<ImmutableEntry> entryList() {
        if (!this.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry<NottableString, List<NottableString>> entry : this.backingMap.entrySet()) {
                for (NottableString value : entry.getValue()) {
                    entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NottableStringMultiMap)) {
            return false;
        }
        NottableStringMultiMap that = (NottableStringMultiMap)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.backingMap, that.backingMap) && Objects.equals(this.regexStringMatcher, that.regexStringMatcher) && this.getKeyMatchStyle() == that.getKeyMatchStyle();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.backingMap, this.regexStringMatcher, this.getKeyMatchStyle());
    }
}

