/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareMetricsReporter;

public class ClusterAwareTimeMetricsHolder
implements ClusterAwareMetricsReporter<Long> {
    private final String metricName;
    private final ArrayList<Long> times = new ArrayList();

    public ClusterAwareTimeMetricsHolder(String metricName) {
        this.metricName = metricName;
    }

    @Override
    public void register(Long elapsedTime) {
        this.times.add(elapsedTime);
    }

    @Override
    public void reportMetrics(Logger log) {
        int size = this.times.size();
        int index95 = (int)Math.ceil(0.95 * (double)size);
        long[] sortedTimes = this.times.stream().mapToLong(x -> x).sorted().toArray();
        long shortestTime = sortedTimes.length == 0 ? 0L : sortedTimes[0];
        long longestTime = sortedTimes.length == 0 ? 0L : sortedTimes[size - 1];
        long average = (long)Arrays.stream(sortedTimes).mapToDouble(x -> x).average().orElse(0.0);
        StringBuilder logMessage = new StringBuilder(256);
        logMessage.append("** Performance Metrics Report for '").append(this.metricName).append("' **\n");
        logMessage.append("\nNumber of reports: ").append(size);
        if (size > 0) {
            logMessage.append("\nLongest reported time: ").append(longestTime).append(" ms");
            logMessage.append("\nShortest reported time: ").append(shortestTime).append(" ms");
            logMessage.append("\nAverage query execution time: ").append(average).append(" ms");
            logMessage.append("\np95 value: ").append(sortedTimes[index95 - 1]);
        }
        log.log(Level.INFO, logMessage.toString());
    }
}

