/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca.metrics;

import java.util.logging.Level;
import java.util.logging.Logger;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareMetricsReporter;

public class ClusterAwareHitMissMetricsHolder
implements ClusterAwareMetricsReporter<Boolean> {
    protected String metricName;
    protected int numberOfReports;
    protected int numberOfHits;
    private final Object lockObject = new Object();

    public ClusterAwareHitMissMetricsHolder(String metricName) {
        this.metricName = metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Boolean isHit) {
        Object object = this.lockObject;
        synchronized (object) {
            ++this.numberOfReports;
            if (isHit.booleanValue()) {
                ++this.numberOfHits;
            }
        }
    }

    @Override
    public void reportMetrics(Logger log) {
        StringBuilder logMessage = new StringBuilder(256);
        logMessage.append("** Performance Metrics Report for '");
        logMessage.append(this.metricName);
        logMessage.append("' **\n");
        logMessage.append("\nNumber of reports: ").append(this.numberOfReports);
        if (this.numberOfReports > 0) {
            logMessage.append("\nNumber of hits: ").append(this.numberOfHits);
            logMessage.append("\nRatio: ").append((double)this.numberOfHits * 100.0 / (double)this.numberOfReports).append(" %");
        }
        log.log(Level.INFO, logMessage.toString());
    }
}

