/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RdsDnsAnalyzer {
    private final Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraCustomClusterPattern = Pattern.compile("(.+)\\.(cluster-custom-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraProxyDnsPattern = Pattern.compile("(.+)\\.(proxy-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);

    public boolean isRdsDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return matcher.find();
    }

    public boolean isRdsProxyDns(String host) {
        Matcher matcher = this.auroraProxyDnsPattern.matcher(host);
        return matcher.find();
    }

    public boolean isRdsClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        return "cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword);
    }

    private @Nullable String getClusterKeyword(Matcher matcher) {
        if (matcher.find() && matcher.groupCount() >= 2 && matcher.group(2) != null && matcher.group(1) != null) {
            boolean isGroup1NotEmpty;
            String group1 = matcher.group(1);
            if (group1 == null) {
                return null;
            }
            boolean bl = isGroup1NotEmpty = !group1.isEmpty();
            if (isGroup1NotEmpty) {
                return matcher.group(2);
            }
        }
        return null;
    }

    public boolean isWriterClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return "cluster-".equalsIgnoreCase(this.getClusterKeyword(matcher));
    }

    public boolean isReaderClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return "cluster-ro-".equalsIgnoreCase(this.getClusterKeyword(matcher));
    }

    public boolean isRdsCustomClusterDns(String host) {
        Matcher matcher = this.auroraCustomClusterPattern.matcher(host);
        return matcher.find();
    }

    public @Nullable String getRdsInstanceHostPattern(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        if (matcher.find() && matcher.groupCount() >= 3) {
            return "?." + matcher.group(3);
        }
        return null;
    }

    public @Nullable String getRdsClusterHostUrl(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        if (("cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword)) && matcher.groupCount() >= 3) {
            return matcher.group(1) + ".cluster-" + matcher.group(3);
        }
        return null;
    }
}

