/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.ca.ConnectionProvider;
import software.aws.rds.jdbc.postgresql.ca.HostInfo;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverResult;
import software.aws.rds.jdbc.postgresql.ca.TopologyService;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.core.BaseConnection;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.Util;

public class ClusterAwareReaderFailoverHandler
implements ReaderFailoverHandler {
    protected static final int DEFAULT_FAILOVER_TIMEOUT = 60000;
    protected static final int DEFAULT_READER_CONNECT_TIMEOUT = 30000;
    protected static final int WRITER_CONNECTION_INDEX = 0;
    private static final transient Logger LOGGER = Logger.getLogger(ClusterAwareReaderFailoverHandler.class.getName());
    protected int maxFailoverTimeoutMs;
    protected int timeoutMs;
    protected final ConnectionProvider connProvider;
    protected final TopologyService topologyService;
    protected Properties connectionProps;

    public ClusterAwareReaderFailoverHandler(TopologyService topologyService, ConnectionProvider connProvider, Properties connectionProps) {
        this(topologyService, connProvider, connectionProps, 60000, 30000);
    }

    public ClusterAwareReaderFailoverHandler(TopologyService topologyService, ConnectionProvider connProvider, Properties connectionProps, int failoverTimeoutMs, int timeoutMs) {
        this.topologyService = topologyService;
        this.connProvider = connProvider;
        this.connectionProps = connectionProps;
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.timeoutMs = timeoutMs;
    }

    protected void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public ReaderFailoverResult failover(List<HostInfo> hosts, @Nullable HostInfo currentHost) throws SQLException {
        if (hosts.isEmpty()) {
            LOGGER.log(Level.FINE, "[ClusterAwareReaderFailoverHandler] failover was called with an invalid (empty) topology");
            return new ReaderFailoverResult(null, null, false);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<ReaderFailoverResult> future = this.submitInternalFailoverTask(hosts, currentHost, executor);
        return this.getInternalFailoverResult(executor, future);
    }

    private Future<ReaderFailoverResult> submitInternalFailoverTask(List<HostInfo> hosts, @Nullable HostInfo currentHost, ExecutorService executor) {
        Future<ReaderFailoverResult> future = executor.submit(() -> {
            ReaderFailoverResult result = null;
            while (result == null || !result.isConnected()) {
                result = this.failoverInternal(hosts, currentHost);
                TimeUnit.SECONDS.sleep(1L);
            }
            return result;
        });
        executor.shutdown();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getInternalFailoverResult(ExecutorService executor, Future<ReaderFailoverResult> future) throws SQLException {
        ReaderFailoverResult defaultResult = new ReaderFailoverResult(null, null, false);
        try {
            ReaderFailoverResult result = future.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            ReaderFailoverResult readerFailoverResult = result == null ? defaultResult : result;
            return readerFailoverResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Thread was interrupted.", "70100", e);
        }
        catch (ExecutionException e) {
            ReaderFailoverResult readerFailoverResult = defaultResult;
            return readerFailoverResult;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            ReaderFailoverResult readerFailoverResult = defaultResult;
            return readerFailoverResult;
        }
        finally {
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
    }

    protected ReaderFailoverResult failoverInternal(List<HostInfo> hosts, @Nullable HostInfo currentHost) throws SQLException {
        this.topologyService.addToDownHostList(currentHost);
        if (hosts.isEmpty()) {
            return new ReaderFailoverResult(null, null, false);
        }
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostInfo> hostsByPriority = this.getHostsByPriority(hosts, downHosts);
        return this.getConnectionFromHostList(hostsByPriority);
    }

    List<HostInfo> getHostsByPriority(List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostInfo> hostsByPriority = new ArrayList<HostInfo>();
        this.addActiveReaders(hostsByPriority, hosts, downHosts);
        HostInfo writerHost = hosts.get(0);
        if (writerHost != null) {
            hostsByPriority.add(writerHost);
        }
        this.addDownHosts(hostsByPriority, hosts, downHosts);
        return hostsByPriority;
    }

    private void addActiveReaders(List<HostInfo> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostInfo> activeReaders = new ArrayList<HostInfo>();
        if (hosts != null) {
            for (int i = 1; i < hosts.size(); ++i) {
                HostInfo host = hosts.get(i);
                if (downHosts.contains(host.getHostPortPair())) continue;
                activeReaders.add(host);
            }
            Collections.shuffle(activeReaders);
            list.addAll(activeReaders);
        }
    }

    private void addDownHosts(List<HostInfo> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostInfo> downHostList = new ArrayList<HostInfo>();
        for (HostInfo host : hosts) {
            if (host == null || !downHosts.contains(host.getHostPortPair())) continue;
            downHostList.add(host);
        }
        Collections.shuffle(downHostList);
        list.addAll(downHostList);
    }

    @Override
    public ReaderFailoverResult getReaderConnection(List<HostInfo> hostList) throws SQLException {
        if (hostList.isEmpty()) {
            LOGGER.log(Level.FINE, "[ClusterAwareReaderFailoverHandler] getReaderConnection was called with an invalid (empty) topology");
            return new ReaderFailoverResult(null, null, false);
        }
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostInfo> readerHosts = this.getReaderHostsByPriority(hostList, downHosts);
        return this.getConnectionFromHostList(readerHosts);
    }

    List<HostInfo> getReaderHostsByPriority(List<HostInfo> hostList, Set<String> downHosts) {
        ArrayList<HostInfo> readerHosts = new ArrayList<HostInfo>();
        this.addActiveReaders(readerHosts, hostList, downHosts);
        this.addDownReaders(readerHosts, hostList, downHosts);
        return readerHosts;
    }

    private void addDownReaders(List<HostInfo> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostInfo> downReaders = new ArrayList<HostInfo>();
        if (hosts != null) {
            for (int i = 1; i < hosts.size(); ++i) {
                HostInfo host = hosts.get(i);
                if (!downHosts.contains(host.getHostPortPair())) continue;
                downReaders.add(host);
            }
            Collections.shuffle(downReaders);
            list.addAll(downReaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getConnectionFromHostList(List<HostInfo> hosts) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<ReaderFailoverResult> completionService = new ExecutorCompletionService<ReaderFailoverResult>(executor);
        try {
            for (int i = 0; i < hosts.size(); i += 2) {
                ReaderFailoverResult result = this.getResultFromNextTaskBatch(hosts, executor, completionService, i);
                if (result.isConnected()) {
                    ReaderFailoverResult readerFailoverResult = result;
                    return readerFailoverResult;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException("Thread was interrupted.", "70100", e);
                }
            }
            ReaderFailoverResult readerFailoverResult = new ReaderFailoverResult(null, null, false);
            return readerFailoverResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ReaderFailoverResult getResultFromNextTaskBatch(List<HostInfo> hostGroup, ExecutorService executor, CompletionService<ReaderFailoverResult> completionService, int i) throws SQLException {
        int numTasks = i + 1 < hostGroup.size() ? 2 : 1;
        completionService.submit(new ConnectionAttemptTask(hostGroup.get(i)));
        if (numTasks == 2) {
            completionService.submit(new ConnectionAttemptTask(hostGroup.get(i + 1)));
        }
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            ReaderFailoverResult result = this.getNextResult(completionService);
            if (!result.isConnected()) continue;
            this.logConnectionSuccess(result);
            executor.shutdownNow();
            return result;
        }
        return new ReaderFailoverResult(null, null, false);
    }

    private ReaderFailoverResult getNextResult(CompletionService<ReaderFailoverResult> service) throws SQLException {
        ReaderFailoverResult defaultResult = new ReaderFailoverResult(null, null, false);
        try {
            Future<ReaderFailoverResult> future = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (future == null) {
                return new ReaderFailoverResult(null, null, false);
            }
            ReaderFailoverResult result = future.get();
            return result == null ? defaultResult : result;
        }
        catch (ExecutionException e) {
            return defaultResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Thread was interrupted.", "70100", e);
        }
    }

    private void logConnectionSuccess(ReaderFailoverResult result) {
        String hostPortPair = "<null>";
        HostInfo host = result.getHost();
        if (host != null) {
            hostPortPair = host.getHostPortPair();
        }
        LOGGER.log(Level.FINE, "[ClusterAwareReaderFailoverHandler] Established read-only connection to ''{0}''", hostPortPair);
    }

    private class ConnectionAttemptTask
    implements Callable<ReaderFailoverResult> {
        private final HostInfo newHost;

        private ConnectionAttemptTask(HostInfo newHost) {
            this.newHost = newHost;
        }

        @Override
        public ReaderFailoverResult call() {
            if (Util.isNullOrEmpty(this.newHost.getHost())) {
                return new ReaderFailoverResult(null, null, false);
            }
            LOGGER.log(Level.FINE, "[ClusterAwareReaderFailoverHandler] Attempting to establish read-only connection to ''{0}''", this.newHost.getHostPortPair());
            try {
                BaseConnection conn = ClusterAwareReaderFailoverHandler.this.connProvider.connect(this.newHost.toHostSpec(), ClusterAwareReaderFailoverHandler.this.connectionProps, this.newHost.getUrl(ClusterAwareReaderFailoverHandler.this.connectionProps));
                ClusterAwareReaderFailoverHandler.this.topologyService.removeFromDownHostList(this.newHost);
                return new ReaderFailoverResult(conn, this.newHost, true);
            }
            catch (SQLException e) {
                ClusterAwareReaderFailoverHandler.this.topologyService.addToDownHostList(this.newHost);
                LOGGER.log(Level.FINE, "[ClusterAwareReaderFailoverHandler] Failed to establish read-only connection to ''{0}''", this.newHost);
                return new ReaderFailoverResult(null, null, false);
            }
        }
    }
}

