/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.sql.SQLException;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.ca.ConnectionProvider;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.core.BaseConnection;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.jdbc.PgConnection;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.HostSpec;

public class BasicConnectionProvider
implements ConnectionProvider {
    @Override
    public BaseConnection connect(HostSpec hostSpec, Properties props, @Nullable String url) throws SQLException {
        if (url == null) {
            return new PgConnection(new HostSpec[]{hostSpec}, this.user(props), this.database(props), props, "");
        }
        return new PgConnection(new HostSpec[]{hostSpec}, this.user(props), this.database(props), props, url);
    }

    private String user(Properties props) {
        return props.getProperty("user", "");
    }

    private String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }
}

