/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.ca.ClusterAwareConnectionProxy;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.PGProperty;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.jdbc.PgConnection;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.ExpressionProperties;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.GT;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.HostSpec;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.LogWriterHandler;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLException;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLState;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.SharedTimer;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.URLCoder;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.Util;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.internal.Nullness;

public class Driver
extends software.aws.rds.jdbc.postgresql.shading.org.postgresql.Driver {
    public static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String AWS_PROTOCOL = "jdbc:postgresql:aws:";
    private static final Logger PARENT_LOGGER = Logger.getLogger(Util.shadingPrefix("software.aws.rds.jdbc.postgresql"));
    private static final Logger LOGGER = Logger.getLogger(Util.shadingPrefix("software.aws.rds.jdbc.postgresql.Driver"));
    private static boolean acceptAwsProtocolOnly = false;

    public static void setAcceptAwsProtocolOnly(boolean awsProtocolOnly) {
        acceptAwsProtocolOnly = awsProtocolOnly;
    }

    @Override
    protected @NonNull Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("software/aws/rds/jdbc/postgresql/shading/org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public @Nullable Connection connect(@Nullable String url, @Nullable Properties info) throws SQLException {
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith(POSTGRES_PROTOCOL)) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        try {
            this.setupLoggerFromProperties(props);
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (driverLogLevel == null) {
            return;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        }
        ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
        String driverLogFile = PGProperty.LOGGER_FILE.get(exprProps);
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            if (DriverManager.getLogWriter() != null) {
                handler = new LogWriterHandler(DriverManager.getLogWriter());
            } else if (DriverManager.getLogStream() != null) {
                handler = new StreamHandler(DriverManager.getLogStream(), formatter);
            } else {
                handler = new ConsoleHandler();
                handler.setFormatter(formatter);
            }
        } else {
            handler.setFormatter(formatter);
        }
        Level loggerLevel = PARENT_LOGGER.getLevel();
        if (loggerLevel != null) {
            handler.setLevel(loggerLevel);
        }
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static @Nullable Connection makeConnection(String url, Properties props) throws SQLException {
        if (url.startsWith(AWS_PROTOCOL)) {
            ClusterAwareConnectionProxy connProxy = new ClusterAwareConnectionProxy(Driver.hostSpecs(props)[0], props, url);
            if (connProxy.isFailoverEnabled()) {
                return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)connProxy);
            }
            return connProxy.getConnection();
        }
        boolean awsProtocolOnly = Driver.isAcceptAwsProtocolOnly(props);
        return awsProtocolOnly ? null : new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(@NonNull String url) {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public @NonNull DriverPropertyInfo[] getPropertyInfo(@NonNull String url, @NonNull Properties info) {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    public static @Nullable Properties parseURL(String url, @Nullable Properties defaults) {
        String[] args;
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        }
        if (!urlServer.startsWith(POSTGRES_PROTOCOL)) {
            String errorMessage = "JDBC URL must start with \"jdbc:postgresql:\" or \"jdbc:postgresql:aws:\" but was: {0}";
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:postgresql:\" or \"jdbc:postgresql:aws:\" but was: {0}", url);
            return null;
        }
        String string = urlServer = urlServer.startsWith(AWS_PROTOCOL) ? urlServer.substring(AWS_PROTOCOL.length()) : urlServer.substring(POSTGRES_PROTOCOL.length());
        if (urlServer.startsWith("//")) {
            int slash = (urlServer = urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                return null;
            }
            urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
            String[] addresses = urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 1 || port > 65535) {
                            LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                            return null;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append("5432");
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PGPORT", ports.toString());
            urlProps.setProperty("PGHOST", hosts.toString());
        } else {
            if (defaults == null || !defaults.containsKey("PGPORT")) {
                urlProps.setProperty("PGPORT", "5432");
            }
            if (defaults == null || !defaults.containsKey("PGHOST")) {
                urlProps.setProperty("PGHOST", "localhost");
            }
            if (defaults == null || !defaults.containsKey("PGDBNAME")) {
                urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer));
            }
        }
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), URLCoder.decode(token.substring(pos + 1)));
        }
        boolean awsProtocolOnly = Driver.isAcceptAwsProtocolOnly(urlProps);
        if (awsProtocolOnly && !url.startsWith(AWS_PROTOCOL)) {
            String urlRejectedMessage = "acceptAwsProtocolOnly mode is enabled; JDBC URL must start with \"jdbc:postgresql:aws:\" but was: {0}";
            LOGGER.log(Level.FINE, "acceptAwsProtocolOnly mode is enabled; JDBC URL must start with \"jdbc:postgresql:aws:\" but was: {0}", url);
            return null;
        }
        return urlProps;
    }

    private static boolean isAcceptAwsProtocolOnly(Properties props) {
        if (props.get(PGProperty.ACCEPT_AWS_PROTOCOL_ONLY.getName()) != null) {
            return PGProperty.ACCEPT_AWS_PROTOCOL_ONLY.getBoolean(props);
        }
        return acceptAwsProtocolOnly;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(props.getProperty("PGHOST")).split(",");
        String[] ports = Nullness.castNonNull(props.getProperty("PGPORT")).split(",");
        String localSocketAddress = props.getProperty("localSocketAddress");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]), localSocketAddress);
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, @NonNull String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    public static @NonNull SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException("software.aws.rds.jdbc.postgresql.shading.org.postgresql.Driver is not supported and thus should never have been registered. software.aws.rds.jdbc.postgresql.Driver should be used instead of this driver.");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private @Nullable Connection result;
        private @Nullable Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

