/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.nio.CharBuffer;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class SimpleParser {
    public static final char EOF = '\u0000';
    private final CharSequence input;
    private final int maxNestingLevel;
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private int nestingLevel = 0;

    public SimpleParser(CharSequence expression) {
        this(expression, 0);
    }

    public SimpleParser(CharSequence input, int maxNestingLevel) {
        this.input = Objects.requireNonNull(input, "expression must not be null");
        this.maxNestingLevel = maxNestingLevel;
        if (maxNestingLevel < 0) {
            throw new IllegalArgumentException("maxNestingLevel must be >= 0");
        }
    }

    public final CharSequence input() {
        return this.input;
    }

    @Deprecated
    public final String expression() {
        return this.input.toString();
    }

    public final int position() {
        return this.position;
    }

    public final int line() {
        return this.line;
    }

    public final int column() {
        return this.column;
    }

    public final void rewind(int position, int line, int column) {
        this.column = column;
        this.line = line;
        this.position = position;
    }

    public final boolean eof() {
        return this.position >= this.input.length();
    }

    public final char peek() {
        return this.peek(0);
    }

    public final char peek(int offset) {
        int target = this.position + offset;
        if (target >= this.input.length() || target < 0) {
            return '\u0000';
        }
        return this.input.charAt(target);
    }

    public final char expect(char token) {
        if (this.peek() == token) {
            this.skip();
            return token;
        }
        throw this.syntax(String.format("Expected: '%s', but found '%s'", Character.valueOf(token), this.peekSingleCharForMessage()));
    }

    public final String peekSingleCharForMessage() {
        char peek = this.peek();
        return peek == '\u0000' ? "[EOF]" : String.valueOf(peek);
    }

    public final char expect(char ... tokens) {
        for (char token : tokens) {
            if (this.peek() != token) continue;
            this.skip();
            return token;
        }
        StringBuilder message = new StringBuilder("Found '").append(this.peekSingleCharForMessage()).append("', but expected one of the following tokens:");
        for (char c : tokens) {
            message.append(' ').append('\'').append(c).append('\'');
        }
        throw this.syntax(message.toString());
    }

    public RuntimeException syntax(String message) {
        return new RuntimeException("Syntax error at line " + this.line() + ", column " + this.column() + ": " + message);
    }

    public void ws() {
        while (this.isWhitespace(this.peek())) {
            this.skip();
        }
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void sp() {
        while (this.isSpace(this.peek())) {
            this.skip();
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public void br() {
        this.sp();
        if (this.eof()) {
            return;
        }
        char c = this.peek();
        if (c != '\n' && c != '\r') {
            throw this.syntax("Expected a line break, but found '" + c + "'");
        }
        this.skip();
    }

    public void skip() {
        if (this.eof()) {
            return;
        }
        switch (this.input.charAt(this.position)) {
            case '\r': {
                if (this.peek(1) == '\n') {
                    ++this.position;
                }
                ++this.line;
                this.column = 1;
                break;
            }
            case '\n': {
                ++this.line;
                this.column = 1;
                break;
            }
            default: {
                ++this.column;
            }
        }
        ++this.position;
    }

    public void consumeRemainingCharactersOnLine() {
        char ch = this.peek();
        while (ch != '\u0000' && ch != '\n' && ch != '\r') {
            this.skip();
            ch = this.peek();
        }
    }

    public final String sliceFrom(int start) {
        return this.input.subSequence(start, this.position).toString();
    }

    public final CharSequence borrowSliceFrom(int start) {
        return CharBuffer.wrap(this.input, start, this.position);
    }

    public final CharSequence borrowSliceFrom(int start, int removeRight) {
        return CharBuffer.wrap(this.input, start, this.position - removeRight);
    }

    @Deprecated
    public final int consumeUntilNoLongerMatches(Predicate<Character> predicate) {
        int startPosition = this.position;
        char ch = this.peek();
        while (ch != '\u0000' && predicate.test(Character.valueOf(ch))) {
            this.skip();
            ch = this.peek();
        }
        return this.position - startPosition;
    }

    public final int consumeWhile(IntPredicate predicate) {
        int startPosition = this.position;
        char ch = this.peek();
        while (ch != '\u0000' && predicate.test(ch)) {
            this.skip();
            ch = this.peek();
        }
        return this.position - startPosition;
    }

    public final void increaseNestingLevel() {
        ++this.nestingLevel;
        if (this.maxNestingLevel > 0 && this.nestingLevel > this.maxNestingLevel) {
            throw this.syntax("Parser exceeded the maximum allowed depth of " + this.maxNestingLevel);
        }
    }

    public final void decreaseNestingLevel() {
        --this.nestingLevel;
        if (this.nestingLevel < 0) {
            throw this.syntax("Invalid parser state. Nesting level set to -1");
        }
    }

    public int nestingLevel() {
        return this.nestingLevel;
    }
}

