/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import software.amazon.smithy.utils.CodeFormatter;
import software.amazon.smithy.utils.CodeInterceptor;
import software.amazon.smithy.utils.CodeInterceptorContainer;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.CodeWriterDebugInfo;
import software.amazon.smithy.utils.CodeWriterFormatterContainer;
import software.amazon.smithy.utils.CopyOnWriteRef;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SimpleCodeWriter;
import software.amazon.smithy.utils.StringUtils;

public abstract class AbstractCodeWriter<T extends AbstractCodeWriter<T>> {
    private static final Pattern LINES = Pattern.compile("\\r?\\n");
    private static final Map<Character, BiFunction<Object, String, String>> DEFAULT_FORMATTERS = MapUtils.of(Character.valueOf('L'), (s, i) -> AbstractCodeWriter.formatLiteral(s), Character.valueOf('S'), (s, i) -> StringUtils.escapeJavaString(AbstractCodeWriter.formatLiteral(s), i));
    private final Deque<State> states = new ArrayDeque<State>();
    private State currentState;
    private boolean trailingNewline = true;
    private int trimBlankLines = -1;
    private boolean enableStackTraceComments;

    public AbstractCodeWriter() {
        this.states.push(new State());
        this.currentState = this.states.getFirst();
        this.currentState.builder = new StringBuilder();
        this.currentState.needsIndentation = true;
    }

    public void copySettingsFrom(AbstractCodeWriter<T> other) {
        this.trailingNewline = other.trailingNewline;
        this.trimBlankLines = other.trimBlankLines;
        this.enableStackTraceComments = other.enableStackTraceComments;
        this.currentState.copyStateFrom(other.currentState);
    }

    public static String formatLiteral(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.isPresent() ? AbstractCodeWriter.formatLiteral(optional.get()) : "";
        }
        return String.valueOf(value);
    }

    public T putFormatter(char identifier, BiFunction<Object, String, String> formatFunction) {
        ((CodeWriterFormatterContainer)this.currentState.formatters.get()).putFormatter(Character.valueOf(identifier), formatFunction);
        return (T)this;
    }

    public T setExpressionStart(char expressionStart) {
        if (expressionStart == ' ' || expressionStart == '\n') {
            throw new IllegalArgumentException("expressionStart must not be set to " + expressionStart);
        }
        this.currentState.expressionStart = expressionStart;
        return (T)this;
    }

    public char getExpressionStart() {
        return this.currentState.expressionStart;
    }

    public String toString() {
        String result = this.currentState.toString();
        if (this.trimBlankLines > -1) {
            StringBuilder builder = new StringBuilder(result.length());
            String[] lines = LINES.split(result);
            int blankCount = 0;
            for (String line : lines) {
                if (!StringUtils.isBlank(line)) {
                    builder.append(line).append(this.currentState.newline);
                    blankCount = 0;
                    continue;
                }
                if (blankCount++ >= this.trimBlankLines) continue;
                builder.append(line).append(this.currentState.newline);
            }
            result = builder.toString();
        }
        if (result.isEmpty()) {
            return this.trailingNewline ? this.currentState.newline : "";
        }
        if (this.currentState.trimTrailingSpaces) {
            result = StringUtils.stripEnd(result, " ");
        }
        if (this.trailingNewline) {
            return result.endsWith(this.currentState.newline) ? result : result + this.currentState.newline;
        }
        if (result.endsWith(this.currentState.newline)) {
            return result.substring(0, result.length() - this.currentState.newline.length());
        }
        return result;
    }

    public T pushState() {
        this.currentState = new State(this.currentState);
        this.states.push(this.currentState);
        return (T)this;
    }

    public T pushState(String sectionName) {
        return this.pushState(CodeSection.forName(sectionName));
    }

    public T pushState(CodeSection section) {
        this.pushState();
        this.currentState.makeInterceptableCodeSection(section);
        return (T)this;
    }

    public T injectSection(CodeSection section) {
        return ((AbstractCodeWriter)this.pushState(section)).popState();
    }

    private String getStateDebugPath() {
        StringJoiner result = new StringJoiner("/");
        Iterator<State> iterator = this.states.descendingIterator();
        while (iterator.hasNext()) {
            result.add(iterator.next().getSectionName());
        }
        return result.toString();
    }

    public final CodeWriterDebugInfo getDebugInfo() {
        return this.getDebugInfo(2);
    }

    public CodeWriterDebugInfo getDebugInfo(int numberOfContextLines) {
        CodeWriterDebugInfo info = new CodeWriterDebugInfo();
        info.putMetadata("path", this.getStateDebugPath());
        if (numberOfContextLines < 0) {
            throw new IllegalArgumentException("Cannot get fewer than 0 lines");
        }
        if (numberOfContextLines > 0) {
            StringBuilder lastLines = new StringBuilder();
            String str = this.toString();
            if (!str.isEmpty()) {
                int startPosition;
                String[] lines = str.split("\r?\n", 0);
                for (int i = startPosition = Math.max(0, lines.length - numberOfContextLines); i < lines.length; ++i) {
                    lastLines.append(lines[i]).append("\\n");
                }
            }
            info.putMetadata("near", lastLines.toString());
        }
        return info;
    }

    public T pushFilteredState(Function<String, String> filter) {
        CodeSection section = CodeSection.forName("__filtered_state_" + this.states.size() + 1);
        this.pushState(section);
        this.onSection(CodeInterceptor.forName(section.sectionName(), (w, content) -> this.writeInlineWithNoFormatting(filter.apply((String)content))));
        return (T)this;
    }

    public T popState() {
        if (this.states.size() == 1) {
            throw new IllegalStateException("Cannot pop writer state because at the root state");
        }
        State popped = this.states.pop();
        this.currentState = this.states.getFirst();
        CodeSection sectionValue = popped.sectionValue;
        if (sectionValue != null) {
            String result = popped.toString();
            if (!(sectionValue instanceof AnonymousCodeSection)) {
                for (CodeInterceptor interceptor : ((CodeInterceptorContainer)popped.interceptors.peek()).get(sectionValue)) {
                    result = this.interceptSection(popped, interceptor, result);
                }
            }
            if (popped.isInline) {
                StringBuilder builder = popped.getBuilder();
                builder.setLength(0);
                builder.append(result);
            } else if (!result.isEmpty()) {
                this.writeInlineWithNoFormatting(result);
            }
        }
        if (!popped.isInline && popped.needsIndentation) {
            this.currentState.needsIndentation = true;
        }
        return (T)this;
    }

    private String interceptSection(State popped, CodeInterceptor<CodeSection, T> interceptor, String previous) {
        return this.expandSection(new AnonymousCodeSection("__" + popped.getSectionName()), previous, interceptorToCall -> interceptor.write(this, previous, popped.sectionValue));
    }

    public T onSection(String sectionName, Consumer<Object> interceptor) {
        ((CodeInterceptorContainer)this.currentState.interceptors.get()).putInterceptor(CodeInterceptor.forName(sectionName, (w, p) -> {
            String trimmedContent = this.removeTrailingNewline((String)p);
            interceptor.accept(trimmedContent);
        }));
        return (T)this;
    }

    public <S extends CodeSection> T onSection(CodeInterceptor<S, T> interceptor) {
        ((CodeInterceptorContainer)this.currentState.interceptors.get()).putInterceptor(interceptor);
        return (T)this;
    }

    public T disableNewlines() {
        this.currentState.disableNewline = true;
        return (T)this;
    }

    public T enableNewlines() {
        this.currentState.disableNewline = false;
        return (T)this;
    }

    public T setNewline(String newline) {
        if (newline.isEmpty()) {
            return this.disableNewlines();
        }
        this.currentState.newline = newline;
        return this.enableNewlines();
    }

    public T setNewline(char newline) {
        return this.setNewline(String.valueOf(newline));
    }

    public String getNewline() {
        return this.currentState.newline;
    }

    public T setIndentText(String indentText) {
        this.currentState.indent(0, indentText);
        return (T)this;
    }

    public final String getIndentText() {
        return this.currentState.indentText;
    }

    public T trimTrailingSpaces() {
        return this.trimTrailingSpaces(true);
    }

    public T trimTrailingSpaces(boolean trimTrailingSpaces) {
        this.currentState.trimTrailingSpaces = trimTrailingSpaces;
        return (T)this;
    }

    public boolean getTrimTrailingSpaces() {
        return this.currentState.trimTrailingSpaces;
    }

    public T trimBlankLines() {
        return this.trimBlankLines(1);
    }

    public T trimBlankLines(int trimBlankLines) {
        this.trimBlankLines = trimBlankLines;
        return (T)this;
    }

    public int getTrimBlankLines() {
        return this.trimBlankLines;
    }

    public T insertTrailingNewline() {
        return this.insertTrailingNewline(true);
    }

    public T insertTrailingNewline(boolean trailingNewline) {
        this.trailingNewline = trailingNewline;
        return (T)this;
    }

    public boolean getInsertTrailingNewline() {
        return this.trailingNewline;
    }

    public T setNewlinePrefix(String newlinePrefix) {
        this.currentState.newlinePrefix = newlinePrefix;
        return (T)this;
    }

    public String getNewlinePrefix() {
        return this.currentState.newlinePrefix;
    }

    public T indent() {
        return this.indent(1);
    }

    public T indent(int levels) {
        this.currentState.indent(levels, null);
        return (T)this;
    }

    public int getIndentLevel() {
        return this.currentState.indentation;
    }

    public T dedent() {
        return this.dedent(1);
    }

    public T dedent(int levels) {
        int adjusted = levels == -1 ? Integer.MIN_VALUE : -1 * levels;
        this.currentState.indent(adjusted, null);
        return (T)this;
    }

    public T openBlock(String textBeforeNewline, Object ... args) {
        return ((AbstractCodeWriter)this.write(textBeforeNewline, args)).indent();
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[0], f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object arg1, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[]{arg1}, f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object arg1, Object arg2, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[]{arg1, arg2}, f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object arg1, Object arg2, Object arg3, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[]{arg1, arg2, arg3}, f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object arg1, Object arg2, Object arg3, Object arg4, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[]{arg1, arg2, arg3, arg4}, f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Runnable f) {
        return this.openBlock(textBeforeNewline, textAfterNewline, new Object[]{arg1, arg2, arg3, arg4, arg5}, f);
    }

    public T openBlock(String textBeforeNewline, String textAfterNewline, Object[] args, Runnable f) {
        ((AbstractCodeWriter)this.write(textBeforeNewline, args)).indent();
        f.run();
        this.closeBlock(textAfterNewline, new Object[0]);
        return (T)this;
    }

    public T closeBlock(String textAfterNewline, Object ... args) {
        return ((AbstractCodeWriter)this.dedent()).write(textAfterNewline, args);
    }

    public T writeWithNoFormatting(Object content) {
        this.currentState.writeLine(this.findAndFormatStackTraceElement(content.toString(), false));
        return (T)this;
    }

    private String findAndFormatStackTraceElement(String content, boolean inline) {
        if (this.enableStackTraceComments) {
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (!this.isStackTraceRelevant(e)) continue;
                return this.formatWithStackTraceElement(content, e, inline);
            }
        }
        return content;
    }

    protected boolean isStackTraceRelevant(StackTraceElement e) {
        String normalized = e.getClassName().replace("$", ".");
        return !normalized.startsWith("java.") && !normalized.startsWith(AbstractCodeWriter.class.getCanonicalName()) && !normalized.startsWith(this.getClass().getCanonicalName()) && !normalized.equals(SimpleCodeWriter.class.getCanonicalName()) && !normalized.equals("software.amazon.smithy.utils.SymbolWriter");
    }

    protected String formatWithStackTraceElement(String content, StackTraceElement element, boolean inline) {
        return "/* " + element + " */ " + content;
    }

    public final T writeInlineWithNoFormatting(Object content) {
        this.currentState.write(this.findAndFormatStackTraceElement(content.toString(), true));
        return (T)this;
    }

    public final String format(Object content, Object ... args) {
        StringBuilder result = new StringBuilder();
        CodeFormatter.run(result, this, Objects.requireNonNull(content).toString(), args);
        return result.toString();
    }

    public Consumer<T> consumer(Consumer<T> consumer) {
        return consumer;
    }

    public T call(Runnable task) {
        task.run();
        return (T)this;
    }

    public T write(Object content, Object ... args) {
        return this.writeWithNoFormatting(this.format(content, args));
    }

    public T writeInline(Object content, Object ... args) {
        return this.writeInlineWithNoFormatting(this.format(content, args));
    }

    public T ensureNewline() {
        if (!this.builderEndsWith(this.currentState.getBuilder(), this.getNewline())) {
            this.write("", new Object[0]);
        }
        return (T)this;
    }

    private boolean builderEndsWith(StringBuilder builder, String check) {
        return builder.length() > check.length() && builder.substring(builder.length() - check.length(), builder.length()).equals(check);
    }

    public T writeOptional(Object content) {
        if (content == null) {
            return (T)this;
        }
        if (content instanceof Optional) {
            return this.writeOptional(((Optional)content).orElse(null));
        }
        String value = content.toString();
        return (T)(!value.isEmpty() ? this.write(value, new Object[0]) : this);
    }

    public T unwrite(Object content, Object ... args) {
        String value = this.format(content, args);
        int currentLength = this.currentState.builder.length();
        if (this.currentState.builder.lastIndexOf(value) == currentLength - value.length()) {
            this.currentState.builder.setLength(currentLength - value.length());
        }
        return (T)this;
    }

    public T putContext(String key, Object value) {
        ((Map)this.currentState.context.get()).put(key, value);
        return (T)this;
    }

    public T putContext(Map<String, Object> mappings) {
        mappings.forEach(this::putContext);
        return (T)this;
    }

    public T removeContext(String key) {
        if (((Map)this.currentState.context.peek()).containsKey(key)) {
            ((Map)this.currentState.context.get()).remove(key);
        }
        return (T)this;
    }

    public Object getContext(String key) {
        Method method;
        CodeSection section = this.currentState.sectionValue;
        Map currentContext = (Map)this.currentState.context.peek();
        if (currentContext.containsKey(key)) {
            return currentContext.get(key);
        }
        if (section != null && (method = this.findContextMethod(section, key)) != null) {
            try {
                return method.invoke((Object)section, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Unable to get context '%s' from a matching method of the current CodeSection: %s %s", key, e.getCause() != null ? e.getCause().getMessage() : e.getMessage(), this.getDebugInfo());
                throw new RuntimeException(message, e);
            }
        }
        return null;
    }

    private Method findContextMethod(CodeSection section, String key) {
        for (Method method : section.getClass().getMethods()) {
            if (!method.getName().equals(key) && !method.getName().equals("get" + StringUtils.capitalize(key)) || method.getReturnType().equals(Void.TYPE)) continue;
            return method;
        }
        return null;
    }

    public <C> C getContext(String key, Class<C> type) {
        Object value = this.getContext(key);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (C)value;
        }
        throw new ClassCastException(String.format("Expected context value '%s' to be an instance of %s, but found %s %s", key, type.getName(), value.getClass().getName(), this.getDebugInfo()));
    }

    public final T enableStackTraceComments(boolean enableStackTraceComments) {
        this.enableStackTraceComments = enableStackTraceComments;
        return (T)this;
    }

    String expandSection(CodeSection section, String previousContent, Consumer<String> consumer) {
        StringBuilder buffer = new StringBuilder();
        this.pushState(section);
        this.currentState.makeSectionInline(buffer);
        consumer.accept(previousContent);
        this.popState();
        return buffer.toString();
    }

    String applyFormatter(char identifier, Object value) {
        BiFunction<Object, String, String> f = ((CodeWriterFormatterContainer)this.currentState.formatters.peek()).getFormatter(identifier);
        if (f != null) {
            return f.apply(value, this.getIndentText());
        }
        if (identifier == 'C') {
            AnonymousCodeSection section = new AnonymousCodeSection("__C_formatter_" + this.states.size());
            if (value instanceof Runnable) {
                Runnable runnable = (Runnable)value;
                return this.removeTrailingNewline(this.expandSection(section, "", ignore -> runnable.run()));
            }
            if (value instanceof Consumer) {
                Consumer consumer = (Consumer)value;
                return this.removeTrailingNewline(this.expandSection(section, "", ignore -> consumer.accept(this)));
            }
            throw new ClassCastException(String.format("Expected value for 'C' formatter to be an instance of %s or %s, but found %s %s", Runnable.class.getName(), Consumer.class.getName(), value.getClass().getName(), this.getDebugInfo()));
        }
        return null;
    }

    String removeTrailingNewline(String value) {
        if (value.endsWith(this.currentState.newline)) {
            value = value.substring(0, value.length() - this.currentState.newline.length());
        }
        return value;
    }

    private final class State {
        private final boolean isRoot;
        private String indentText = "    ";
        private String leadingIndentString = "";
        private String newlinePrefix = "";
        private int indentation;
        private boolean trimTrailingSpaces;
        private boolean disableNewline;
        private String newline = "\n";
        private char expressionStart = (char)36;
        private boolean needsIndentation;
        private CodeSection sectionValue;
        private CopyOnWriteRef<Map<String, Object>> context;
        private CopyOnWriteRef<CodeWriterFormatterContainer> formatters;
        private CopyOnWriteRef<CodeInterceptorContainer<T>> interceptors;
        private StringBuilder builder;
        private boolean isInline;

        State() {
            this.builder = new StringBuilder();
            this.isRoot = true;
            CodeWriterFormatterContainer formatterContainer = new CodeWriterFormatterContainer();
            DEFAULT_FORMATTERS.forEach(formatterContainer::putFormatter);
            this.formatters = CopyOnWriteRef.fromOwned(formatterContainer);
            this.context = CopyOnWriteRef.fromOwned(new HashMap());
            this.interceptors = CopyOnWriteRef.fromOwned(new CodeInterceptorContainer());
        }

        State(State copy) {
            this.isRoot = false;
            this.copyStateFrom(copy);
            this.builder = copy.builder;
        }

        private void copyStateFrom(State copy) {
            this.newline = copy.newline;
            this.expressionStart = copy.expressionStart;
            this.context = copy.context;
            this.indentText = copy.indentText;
            this.leadingIndentString = copy.leadingIndentString;
            this.indentation = copy.indentation;
            this.newlinePrefix = copy.newlinePrefix;
            this.trimTrailingSpaces = copy.trimTrailingSpaces;
            this.disableNewline = copy.disableNewline;
            this.needsIndentation = copy.needsIndentation;
            this.context = CopyOnWriteRef.fromBorrowed(copy.context.peek(), HashMap::new);
            this.formatters = CopyOnWriteRef.fromBorrowed(copy.formatters.peek(), CodeWriterFormatterContainer::new);
            this.interceptors = CopyOnWriteRef.fromBorrowed(copy.interceptors.peek(), CodeInterceptorContainer::new);
        }

        public String toString() {
            return this.getBuilder().toString();
        }

        StringBuilder getBuilder() {
            return this.builder;
        }

        void write(String contents) {
            int position = 0;
            int nextNewline = contents.indexOf(this.newline);
            while (nextNewline > -1) {
                while (position < nextNewline) {
                    this.append(contents.charAt(position));
                    ++position;
                }
                this.writeNewline();
                nextNewline = contents.indexOf(this.newline, position += this.newline.length());
            }
            while (position < contents.length()) {
                this.append(contents.charAt(position));
                ++position;
            }
        }

        private void append(char c) {
            this.checkIndentationBeforeWriting();
            this.getBuilder().append(c);
        }

        private void checkIndentationBeforeWriting() {
            if (this.needsIndentation) {
                this.getBuilder().append(this.leadingIndentString).append(this.newlinePrefix);
                this.needsIndentation = false;
            }
        }

        private void writeNewline() {
            this.checkIndentationBeforeWriting();
            this.trimSpaces();
            this.getBuilder().append(this.newline);
            this.needsIndentation = true;
        }

        private void writeLine(String line) {
            this.write(line);
            if (!this.disableNewline) {
                this.writeNewline();
            }
        }

        private void trimSpaces() {
            if (!this.trimTrailingSpaces) {
                return;
            }
            StringBuilder buffer = this.getBuilder();
            int toRemove = 0;
            for (int i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' '; --i) {
                ++toRemove;
            }
            if (toRemove > 0) {
                buffer.delete(buffer.length() - toRemove, buffer.length());
            }
        }

        private void indent(int levels, String indentText) {
            if (levels == Integer.MIN_VALUE) {
                this.indentation = 0;
            } else {
                if (levels + this.indentation < 0) {
                    throw new IllegalStateException(String.format("Cannot dedent writer %d levels", levels));
                }
                this.indentation += levels;
            }
            if (indentText != null) {
                this.indentText = indentText;
            }
            this.leadingIndentString = StringUtils.repeat(this.indentText, this.indentation);
        }

        private void makeSectionInline(StringBuilder builder) {
            this.isInline = true;
            this.builder = builder;
        }

        private void makeInterceptableCodeSection(CodeSection section) {
            ((AbstractCodeWriter)AbstractCodeWriter.this).currentState.sectionValue = section;
            ((AbstractCodeWriter)AbstractCodeWriter.this).currentState.builder = new StringBuilder();
            ((AbstractCodeWriter)AbstractCodeWriter.this).currentState.newlinePrefix = "";
            AbstractCodeWriter.this.dedent(-1);
        }

        private String getSectionName() {
            if (this.isRoot) {
                return "ROOT";
            }
            if (this.sectionValue == null) {
                return "UNNAMED";
            }
            return this.sectionValue.sectionName();
        }
    }

    private static final class AnonymousCodeSection
    implements CodeSection {
        private final String sectionName;

        private AnonymousCodeSection(String sectionName) {
            this.sectionName = Objects.requireNonNull(sectionName);
        }

        @Override
        public String sectionName() {
            return this.sectionName;
        }
    }
}

