/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Objects;
import software.amazon.smithy.utils.Pair;

public final class Triple<L, M, R> {
    public final L left;
    public final M middle;
    public final R right;

    private Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public static <L, M, R> Triple<L, M, R> fromPair(Pair<L, M> pair, R right) {
        return Triple.of(pair.left, pair.right, right);
    }

    public L getLeft() {
        return this.left;
    }

    public M getMiddle() {
        return this.middle;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.left, triple.left) && Objects.equals(this.middle, triple.middle) && Objects.equals(this.right, triple.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.middle, this.right);
    }

    public String toString() {
        return "(" + this.left + ", " + this.middle + ", " + this.right + ")";
    }
}

