/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocol.traits;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.protocol.traits.Rpcv2CborTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class Rpcv2CborTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape serviceShape : model.getServiceShapesWithTrait(Rpcv2CborTrait.class)) {
            Rpcv2CborTrait protocolTrait = (Rpcv2CborTrait)serviceShape.expectTrait(Rpcv2CborTrait.class);
            ArrayList<String> invalid = new ArrayList<String>(protocolTrait.getEventStreamHttp());
            invalid.removeAll(protocolTrait.getHttp());
            if (invalid.isEmpty()) continue;
            events.add(this.error((Shape)serviceShape, (FromSourceLocation)protocolTrait, String.format("The following values of the `eventStreamHttp` property do not also appear in the `http` property of the %s protocol trait: %s", protocolTrait.toShapeId(), invalid)));
        }
        return events;
    }
}

