/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits.eventstream;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.protocoltests.traits.AppliesTo;
import software.amazon.smithy.protocoltests.traits.eventstream.EventStreamTestCase;

public final class EventStreamTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.test#eventStreamTests");
    private final List<EventStreamTestCase> testCases;

    public EventStreamTestsTrait(List<EventStreamTestCase> testCases) {
        this(SourceLocation.NONE, testCases);
    }

    public EventStreamTestsTrait(SourceLocation sourceLocation, List<EventStreamTestCase> testCases) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.testCases = testCases;
    }

    public List<EventStreamTestCase> getTestCases() {
        return this.testCases;
    }

    public List<EventStreamTestCase> getTestCasesFor(AppliesTo appliesTo) {
        return this.testCases.stream().filter(test -> !test.getAppliesTo().filter(value -> value != appliesTo).isPresent()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (!(o instanceof EventStreamTestsTrait)) {
            return false;
        }
        EventStreamTestsTrait that = (EventStreamTestsTrait)((Object)o);
        return Objects.equals(this.testCases, that.testCases);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.testCases);
    }

    protected Node createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(EventStreamTestsTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this);
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            NodeMapper mapper = new NodeMapper();
            ArrayList<EventStreamTestCase> cases = new ArrayList<EventStreamTestCase>(values.size());
            for (Node testCase : values) {
                cases.add((EventStreamTestCase)mapper.deserialize(testCase, EventStreamTestCase.class));
            }
            EventStreamTestsTrait result = new EventStreamTestsTrait(cases);
            result.setNodeCache(value);
            return result;
        }
    }
}

