/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.Collection;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.protocoltests.traits.TestFailureExpectation;
import software.amazon.smithy.utils.ListUtils;

public final class TestExpectation
implements ToNode {
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private final TestFailureExpectation failure;

    private TestExpectation(TestFailureExpectation failure) {
        this.failure = failure;
    }

    public static TestExpectation success() {
        return new TestExpectation(null);
    }

    public static TestExpectation failure(TestFailureExpectation failure) {
        return new TestExpectation(failure);
    }

    public static TestExpectation fromNode(Node node) {
        ObjectNode o = node.expectObjectNode();
        if (o.containsMember(SUCCESS)) {
            o.expectNoAdditionalProperties((Collection)ListUtils.of((Object)SUCCESS));
            return TestExpectation.success();
        }
        if (o.containsMember(FAILURE)) {
            o.expectNoAdditionalProperties((Collection)ListUtils.of((Object)FAILURE));
            TestFailureExpectation failure = TestFailureExpectation.fromNode((Node)o.expectObjectMember(FAILURE));
            return TestExpectation.failure(failure);
        }
        throw new ExpectationNotMetException("Expected an object with exactly one `success` or `failure` property, but found properties: " + ValidationUtils.tickedList(o.getStringMap().keySet()), (FromSourceLocation)o);
    }

    public boolean isSuccess() {
        return this.failure == null;
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public Optional<TestFailureExpectation> getFailure() {
        return Optional.ofNullable(this.failure);
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (this.isSuccess()) {
            builder.withMember(SUCCESS, (ToNode)Node.objectNode());
        } else {
            Node failureNode = this.getFailure().map(TestFailureExpectation::toNode).orElse((Node)Node.objectNode());
            builder.withMember(FAILURE, (ToNode)failureNode);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((TestExpectation)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }
}

