/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestTestsTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class HttpMalformedRequestTestsValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Stream.concat(model.shapes(OperationShape.class), model.shapes(StructureShape.class)).forEach(shape -> shape.getTrait(HttpMalformedRequestTestsTrait.class).ifPresent(trait -> trait.getParameterizedTestCases().forEach(testCase -> {
            Set sizes;
            if (!testCase.getTestParameters().isEmpty() && (sizes = testCase.getTestParameters().values().stream().map(List::size).collect(Collectors.toSet())).size() != 1) {
                events.add(this.error((Shape)shape, (FromSourceLocation)trait.getSourceLocation(), "Each list associated to a key in `testParameters` must be of the same length."));
            }
        })));
        return events;
    }
}

