/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class HttpMalformedRequestDefinition
implements ToNode,
ToSmithyBuilder<HttpMalformedRequestDefinition> {
    private static final String BODY = "body";
    private static final String HEADERS = "headers";
    private static final String HOST = "host";
    private static final String METHOD = "method";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String URI = "uri";
    private final String body;
    private final Map<String, String> headers;
    private final String host;
    private final String method;
    private final List<String> queryParams;
    private final String uri;

    private HttpMalformedRequestDefinition(Builder builder) {
        this.body = builder.body;
        this.host = builder.host;
        this.headers = MapUtils.copyOf((Map)builder.headers);
        this.method = (String)SmithyBuilder.requiredState((String)METHOD, (Object)builder.method);
        this.queryParams = ListUtils.copyOf((Collection)builder.queryParams);
        this.uri = builder.uri;
    }

    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getQueryParams() {
        return this.queryParams;
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public String expectUri() {
        return this.uri;
    }

    public static HttpMalformedRequestDefinition fromNode(Node node) {
        Builder builder = HttpMalformedRequestDefinition.builder();
        ObjectNode o = node.expectObjectNode();
        o.getStringMember(BODY).map(StringNode::getValue).ifPresent(builder::body);
        o.getObjectMember(HEADERS).ifPresent(headers -> headers.getStringMap().forEach((k, v) -> builder.putHeader((String)k, v.expectStringNode().getValue())));
        o.getStringMember(HOST).ifPresent(stringNode -> builder.host(stringNode.getValue()));
        builder.method(o.expectStringMember(METHOD).getValue());
        o.getStringMember(URI).map(StringNode::getValue).ifPresent(builder::uri);
        o.getArrayMember(QUERY_PARAMS).ifPresent(queryParams -> builder.queryParams(queryParams.getElementsAs(StringNode::getValue)));
        return builder.build();
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withOptionalMember(BODY, this.getBody().map(Node::from)).withOptionalMember(HEADERS, this.headers.isEmpty() ? Optional.empty() : Optional.of(ObjectNode.fromStringMap(this.getHeaders()))).withOptionalMember(HOST, this.getHost().map(Node::from)).withMember(METHOD, this.getMethod()).withOptionalMember(URI, this.getUri().map(Node::from)).withOptionalMember(QUERY_PARAMS, this.queryParams.isEmpty() ? Optional.empty() : Optional.of(ArrayNode.fromStrings(this.getQueryParams()))).build();
    }

    public Builder toBuilder() {
        Builder builder = HttpMalformedRequestDefinition.builder().headers(this.getHeaders()).method(this.getMethod()).queryParams(this.getQueryParams());
        this.getBody().ifPresent(builder::body);
        this.getHost().ifPresent(builder::host);
        this.getUri().ifPresent(builder::uri);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<HttpMalformedRequestDefinition> {
        private String body;
        private String host;
        private final Map<String, String> headers = new HashMap<String, String>();
        private String method;
        private final List<String> queryParams = new ArrayList<String>();
        private String uri;

        private Builder() {
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder queryParams(List<String> queryParams) {
            this.queryParams.clear();
            this.queryParams.addAll(queryParams);
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public HttpMalformedRequestDefinition build() {
            return new HttpMalformedRequestDefinition(this);
        }
    }
}

