/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class HttpMalformedResponseBodyDefinition
implements ToNode,
ToSmithyBuilder<HttpMalformedResponseBodyDefinition> {
    private static final String ASSERTION = "assertion";
    private static final String CONTENTS = "contents";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String MESSAGE_REGEX = "messageRegex";
    private final String contents;
    private final String mediaType;
    private final String messageRegex;

    private HttpMalformedResponseBodyDefinition(Builder builder) {
        this.contents = builder.contents;
        this.mediaType = (String)SmithyBuilder.requiredState((String)MEDIA_TYPE, (Object)builder.mediaType);
        this.messageRegex = builder.messageRegex;
    }

    public Optional<String> getContents() {
        return Optional.ofNullable(this.contents);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Optional<String> getMessageRegex() {
        return Optional.ofNullable(this.messageRegex);
    }

    public static HttpMalformedResponseBodyDefinition fromNode(Node node) {
        Builder builder = HttpMalformedResponseBodyDefinition.builder();
        ObjectNode o = node.expectObjectNode();
        builder.mediaType(o.expectStringMember(MEDIA_TYPE).getValue());
        ObjectNode assertion = o.expectObjectMember(ASSERTION);
        assertion.getStringMember(CONTENTS).ifPresent(stringNode -> builder.contents(stringNode.getValue()));
        assertion.getStringMember(MESSAGE_REGEX).ifPresent(stringNode -> builder.messageRegex(stringNode.getValue()));
        return builder.build();
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(MEDIA_TYPE, this.getMediaType()).withMember(ASSERTION, (ToNode)ObjectNode.objectNodeBuilder().withOptionalMember(CONTENTS, this.getContents().map(Node::from)).withOptionalMember(MESSAGE_REGEX, this.getMessageRegex().map(Node::from)).build()).build();
    }

    public Builder toBuilder() {
        Builder builder = HttpMalformedResponseBodyDefinition.builder().mediaType(this.getMediaType());
        this.getContents().ifPresent(builder::mediaType);
        this.getMessageRegex().ifPresent(builder::messageRegex);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<HttpMalformedResponseBodyDefinition> {
        private String contents;
        private String mediaType;
        private String messageRegex;

        private Builder() {
        }

        public Builder contents(String contents) {
            this.contents = contents;
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder messageRegex(String messageRegex) {
            this.messageRegex = messageRegex;
            return this;
        }

        public HttpMalformedResponseBodyDefinition build() {
            return new HttpMalformedResponseBodyDefinition(this);
        }
    }
}

