/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.utils.MediaType;

abstract class ProtocolTestCaseValidator<T extends Trait>
extends AbstractValidator {
    private final Class<T> traitClass;
    private final ShapeId traitId;
    private final String descriptor;
    private final DocumentBuilderFactory documentBuilderFactory;

    ProtocolTestCaseValidator(ShapeId traitId, Class<T> traitClass, String descriptor) {
        this.traitId = traitId;
        this.traitClass = traitClass;
        this.descriptor = descriptor;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.documentBuilderFactory.setXIncludeAware(false);
            this.documentBuilderFactory.setExpandEntityReferences(false);
            this.documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(this.traitClass)) {
            events.addAll(this.validateShape(model, operationIndex, shape, shape.expectTrait(this.traitClass)));
        }
        return events;
    }

    abstract StructureShape getStructure(Shape var1, OperationIndex var2);

    abstract List<? extends HttpMessageTestCase> getTestCases(T var1);

    boolean isValidatedBy(Shape shape) {
        return shape instanceof OperationShape;
    }

    private List<ValidationEvent> validateShape(Model model, OperationIndex operationIndex, Shape shape, T trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<HttpMessageTestCase> testCases = this.getTestCases(trait);
        for (int i = 0; i < testCases.size(); ++i) {
            StructureShape struct;
            HttpMessageTestCase testCase = testCases.get(i);
            events.addAll(this.validateMediaType(shape, (Trait)trait, testCase));
            Optional<ShapeId> vendorParamsShapeOptional = testCase.getVendorParamsShape();
            ObjectNode vendorParams = testCase.getVendorParams();
            if (vendorParamsShapeOptional.isPresent() && this.isValidatedBy(shape)) {
                if (vendorParams.isEmpty()) {
                    events.add(this.warning(shape, (FromSourceLocation)trait, "Protocol test case defined a `vendorParamsShape` but no `vendorParams`"));
                } else {
                    Shape vendorParamsShape = model.expectShape(vendorParamsShapeOptional.get());
                    NodeValidationVisitor vendorParamsValidator = this.createVisitor(vendorParams, model, shape, i, ".vendorParams");
                    events.addAll((Collection)vendorParamsShape.accept((ShapeVisitor)vendorParamsValidator));
                }
            }
            if ((struct = this.getStructure(shape, operationIndex)) != null) {
                NodeValidationVisitor validator = this.createVisitor(testCase.getParams(), model, shape, i, ".params");
                events.addAll((Collection)struct.accept((ShapeVisitor)validator));
                continue;
            }
            if (testCase.getParams().isEmpty() || !this.isValidatedBy(shape)) continue;
            events.add(this.error(shape, (FromSourceLocation)trait, String.format("Protocol test %s parameters provided for operation with no %s: `%s`", this.descriptor, this.descriptor, Node.printJson((Node)testCase.getParams()))));
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(ObjectNode value, Model model, Shape shape, int position, String contextSuffix) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value((Node)value).startingContext(this.traitId + "." + position + contextSuffix).eventId(this.getName()).timestampValidationStrategy(TimestampValidationStrategy.EPOCH_SECONDS).allowBoxedNull(true).build();
    }

    private List<ValidationEvent> validateMediaType(Shape shape, Trait trait, HttpMessageTestCase test) {
        if (!test.getBody().filter(s -> !s.isEmpty()).isPresent()) {
            return Collections.emptyList();
        }
        String rawMediaType = test.getBodyMediaType().orElse("application/octet-stream");
        MediaType mediaType = MediaType.from((String)rawMediaType);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (this.isXml(mediaType)) {
            this.validateXml(shape, trait, test).ifPresent(events::add);
        } else if (this.isJson(mediaType)) {
            this.validateJson(shape, trait, test).ifPresent(events::add);
        }
        return events;
    }

    private boolean isXml(MediaType mediaType) {
        return mediaType.getSubtype().equals("xml") || mediaType.getSuffix().orElse("").equals("xml");
    }

    private boolean isJson(MediaType mediaType) {
        return mediaType.getSubtype().equals("json") || mediaType.getSuffix().orElse("").equals("json");
    }

    private Optional<ValidationEvent> validateXml(Shape shape, Trait trait, HttpMessageTestCase test) {
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(test.getBody().orElse(""))));
            return Optional.empty();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return Optional.of(this.emitMediaTypeError(shape, trait, test, e));
        }
    }

    private Optional<ValidationEvent> validateJson(Shape shape, Trait trait, HttpMessageTestCase test) {
        try {
            Node.parse((String)test.getBody().orElse(""));
            return Optional.empty();
        }
        catch (ModelSyntaxException e) {
            return Optional.of(this.emitMediaTypeError(shape, trait, test, e));
        }
    }

    private ValidationEvent emitMediaTypeError(Shape shape, Trait trait, HttpMessageTestCase test, Throwable e) {
        return this.danger(shape, (FromSourceLocation)trait, String.format("Invalid %s content in `%s` protocol test case `%s`: %s", test.getBodyMediaType().orElse(""), trait.toShapeId(), test.getId(), e.getMessage()));
    }
}

