/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestDefinition;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestTestCase;
import software.amazon.smithy.protocoltests.traits.HttpMalformedResponseBodyDefinition;
import software.amazon.smithy.protocoltests.traits.HttpMalformedResponseDefinition;
import software.amazon.smithy.utils.CodeWriter;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
final class ParameterizedHttpMalformedRequestTestCase
implements Tagged,
ToNode,
ToSmithyBuilder<ParameterizedHttpMalformedRequestTestCase> {
    private static final String DOCUMENTATION = "documentation";
    private static final String ID = "id";
    private static final String PROTOCOL = "protocol";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String TAGS = "tags";
    private static final String TEST_PARAMETERS = "testParameters";
    private final String documentation;
    private final String id;
    private final ShapeId protocol;
    private final HttpMalformedRequestDefinition request;
    private final HttpMalformedResponseDefinition response;
    private final List<String> tags;
    private final Map<String, List<String>> testParameters;

    private ParameterizedHttpMalformedRequestTestCase(Builder builder) {
        this.documentation = builder.documentation;
        this.id = (String)SmithyBuilder.requiredState((String)ID, (Object)builder.id);
        this.protocol = (ShapeId)SmithyBuilder.requiredState((String)PROTOCOL, (Object)builder.protocol);
        this.request = (HttpMalformedRequestDefinition)SmithyBuilder.requiredState((String)REQUEST, (Object)builder.request);
        this.response = (HttpMalformedResponseDefinition)SmithyBuilder.requiredState((String)RESPONSE, (Object)builder.response);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
        this.testParameters = MapUtils.copyOf((Map)builder.testParameters);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public String getId() {
        return this.id;
    }

    public ShapeId getProtocol() {
        return this.protocol;
    }

    public HttpMalformedRequestDefinition getRequest() {
        return this.request;
    }

    public HttpMalformedResponseDefinition getResponse() {
        return this.response;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, List<String>> getTestParameters() {
        return this.testParameters;
    }

    public List<HttpMalformedRequestTestCase> generateTestCasesFromParameters() {
        if (this.testParameters.isEmpty()) {
            HttpMalformedRequestTestCase.Builder builder = HttpMalformedRequestTestCase.builder().id(this.getId()).protocol((ToShapeId)this.getProtocol()).request(this.request).response(this.response).tags(this.getTags());
            this.getDocumentation().ifPresent(builder::documentation);
            return ListUtils.of((Object)builder.build());
        }
        int paramLength = this.testParameters.values().stream().findFirst().map(List::size).orElseThrow(IllegalStateException::new);
        ArrayList<HttpMalformedRequestTestCase> testCases = new ArrayList<HttpMalformedRequestTestCase>(paramLength);
        for (int i = 0; i < paramLength; ++i) {
            CodeWriter writer = new CodeWriter();
            for (Map.Entry<String, List<String>> e : this.testParameters.entrySet()) {
                writer.putContext(e.getKey(), (Object)e.getValue().get(i));
            }
            HttpMalformedRequestTestCase.Builder builder = HttpMalformedRequestTestCase.builder().id(String.format(this.getId() + "_case%d", i)).protocol((ToShapeId)this.getProtocol()).tags(this.getTags().stream().map(x$0 -> writer.format(x$0, new Object[0])).collect(Collectors.toList()));
            this.getDocumentation().map(x$0 -> writer.format(x$0, new Object[0])).ifPresent(builder::documentation);
            testCases.add(builder.request(ParameterizedHttpMalformedRequestTestCase.interpolateRequest(this.request, writer)).response(ParameterizedHttpMalformedRequestTestCase.interpolateResponse(this.response, writer)).build());
        }
        return testCases;
    }

    private static HttpMalformedResponseDefinition interpolateResponse(HttpMalformedResponseDefinition response, CodeWriter writer) {
        HttpMalformedResponseDefinition.Builder responseBuilder = response.toBuilder().headers(ParameterizedHttpMalformedRequestTestCase.formatHeaders(writer, response.getHeaders()));
        response.getBody().map(responseBody -> {
            HttpMalformedResponseBodyDefinition.Builder bodyBuilder = responseBody.toBuilder().mediaType(writer.format((Object)responseBody.getMediaType(), new Object[0]));
            responseBody.getContents().map(x$0 -> writer.format(x$0, new Object[0])).ifPresent(bodyBuilder::contents);
            responseBody.getMessageRegex().map(x$0 -> writer.format(x$0, new Object[0])).ifPresent(bodyBuilder::messageRegex);
            return bodyBuilder.build();
        }).ifPresent(responseBuilder::body);
        return responseBuilder.build();
    }

    private static HttpMalformedRequestDefinition interpolateRequest(HttpMalformedRequestDefinition request, CodeWriter writer) {
        HttpMalformedRequestDefinition.Builder requestBuilder = request.toBuilder().headers(ParameterizedHttpMalformedRequestTestCase.formatHeaders(writer, request.getHeaders())).queryParams(request.getQueryParams().stream().map(x$0 -> writer.format(x$0, new Object[0])).collect(Collectors.toList()));
        request.getBody().map(x$0 -> writer.format(x$0, new Object[0])).ifPresent(requestBuilder::body);
        request.getUri().map(x$0 -> writer.format(x$0, new Object[0])).ifPresent(requestBuilder::uri);
        return requestBuilder.build();
    }

    private static Map<String, String> formatHeaders(CodeWriter writer, Map<String, String> headers) {
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            newHeaders.put(writer.format((Object)headerEntry.getKey(), new Object[0]), writer.format((Object)headerEntry.getValue(), new Object[0]));
        }
        return newHeaders;
    }

    public static ParameterizedHttpMalformedRequestTestCase fromNode(Node node) {
        Builder builder = ParameterizedHttpMalformedRequestTestCase.builder();
        ObjectNode o = node.expectObjectNode();
        o.getStringMember(DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::documentation);
        builder.id(o.expectStringMember(ID).getValue());
        builder.protocol((ToShapeId)o.expectStringMember(PROTOCOL).expectShapeId());
        builder.request(HttpMalformedRequestDefinition.fromNode((Node)o.expectObjectMember(REQUEST)));
        builder.response(HttpMalformedResponseDefinition.fromNode((Node)o.expectObjectMember(RESPONSE)));
        o.getArrayMember(TAGS).ifPresent(tags -> builder.tags(tags.getElementsAs(StringNode::getValue)));
        o.getObjectMember(TEST_PARAMETERS).ifPresent(params -> {
            HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
            for (Map.Entry e : params.getStringMap().entrySet()) {
                paramsMap.put((String)e.getKey(), ((Node)e.getValue()).expectArrayNode().getElementsAs(n -> n.expectStringNode().getValue()));
            }
            builder.testParameters(paramsMap);
        });
        return builder.build();
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember(DOCUMENTATION, this.getDocumentation().map(Node::from)).withMember(ID, this.getId()).withMember(PROTOCOL, this.getProtocol().toString()).withMember(REQUEST, (ToNode)this.getRequest().toNode()).withMember(RESPONSE, (ToNode)this.getResponse().toNode());
        if (!this.tags.isEmpty()) {
            builder.withMember(TAGS, (ToNode)ArrayNode.fromStrings(this.getTags()));
        }
        if (!this.testParameters.isEmpty()) {
            ObjectNode.Builder paramBuilder = ObjectNode.objectNodeBuilder();
            for (Map.Entry<String, List<String>> e : this.getTestParameters().entrySet()) {
                paramBuilder.withMember(e.getKey(), (ToNode)ArrayNode.fromStrings((Collection)e.getValue()));
            }
            builder.withMember(TEST_PARAMETERS, (ToNode)paramBuilder.build());
        }
        return builder.build();
    }

    public Builder toBuilder() {
        Builder builder = ParameterizedHttpMalformedRequestTestCase.builder().id(this.getId()).protocol((ToShapeId)this.getProtocol()).request(this.getRequest()).response(this.getResponse()).tags(this.getTags()).testParameters(this.getTestParameters());
        this.getDocumentation().ifPresent(builder::documentation);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<ParameterizedHttpMalformedRequestTestCase> {
        private String documentation;
        private String id;
        private ShapeId protocol;
        private HttpMalformedRequestDefinition request;
        private HttpMalformedResponseDefinition response;
        private final List<String> tags = new ArrayList<String>();
        private final Map<String, List<String>> testParameters = new HashMap<String, List<String>>();

        private Builder() {
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder protocol(ToShapeId protocol) {
            this.protocol = protocol.toShapeId();
            return this;
        }

        public Builder request(HttpMalformedRequestDefinition request) {
            this.request = request;
            return this;
        }

        public Builder response(HttpMalformedResponseDefinition response) {
            this.response = response;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder testParameters(Map<String, List<String>> testParameters) {
            this.testParameters.clear();
            this.testParameters.putAll(testParameters);
            return this;
        }

        public ParameterizedHttpMalformedRequestTestCase build() {
            return new ParameterizedHttpMalformedRequestTestCase(this);
        }
    }
}

