/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.mappers;

import java.util.Map;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class RemoveEmptyComponents
implements OpenApiMapper {
    private static final String COMPONENTS = "components";

    @Override
    public byte getOrder() {
        return 112;
    }

    @Override
    public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
        ObjectNode components = node.getObjectMember(COMPONENTS).orElse(null);
        if (components == null) {
            return node;
        }
        ObjectNode updatedComponents = (ObjectNode)components.getMembers().entrySet().stream().filter(entry -> !RemoveEmptyComponents.isEmptyObject((Node)entry.getValue())).collect(ObjectNode.collect(Map.Entry::getKey, Map.Entry::getValue));
        return updatedComponents.isEmpty() ? node.withoutMember(COMPONENTS) : node.withMember(COMPONENTS, (ToNode)updatedComponents);
    }

    private static boolean isEmptyObject(Node node) {
        return node.asObjectNode().filter(ObjectNode::isEmpty).isPresent();
    }
}

