/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class Component
implements ToNode {
    private Node node;
    private final Map<String, Node> extensions;

    protected Component(Builder<?, ?> builder) {
        this.extensions = new TreeMap<String, Node>((Map)((Builder)builder).extensions.copy());
    }

    public final Optional<Node> getExtension(String name) {
        return Optional.ofNullable(this.extensions.get(name));
    }

    public final Map<String, Node> getExtensions() {
        return this.extensions;
    }

    public final Node toNode() {
        if (this.node == null) {
            ObjectNode.Builder builder = this.createNodeBuilder();
            for (Map.Entry<String, Node> entry : this.extensions.entrySet()) {
                builder.withMember(entry.getKey(), (ToNode)entry.getValue().toNode());
            }
            this.node = builder.build();
        }
        return this.node;
    }

    protected abstract ObjectNode.Builder createNodeBuilder();

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((Component)o).toNode());
    }

    public final int hashCode() {
        return this.toNode().hashCode();
    }

    public static abstract class Builder<B extends Builder, C extends Component>
    implements SmithyBuilder<C> {
        private final BuilderRef<Map<String, Node>> extensions = BuilderRef.forSortedMap();

        public Map<String, Node> getExtensions() {
            return (Map)this.extensions.get();
        }

        public B extensions(Map<String, Node> extensions) {
            this.extensions.clear();
            extensions.forEach(this::putExtension);
            return (B)this;
        }

        public B extensions(ObjectNode extensions) {
            return this.extensions(extensions.getStringMap());
        }

        public B putExtension(String key, Node value) {
            ((Map)this.extensions.get()).put(key, value);
            return (B)this;
        }

        public B putExtension(String key, String value) {
            return this.putExtension(key, (Node)Node.from((String)value));
        }

        public B putExtension(String key, Boolean value) {
            return this.putExtension(key, (Node)Node.from((boolean)value));
        }

        public B putExtension(String key, Number value) {
            return this.putExtension(key, (Node)Node.from((Number)value));
        }

        public B removeExtension(String key) {
            ((Map)this.extensions.get()).remove(key);
            return (B)this;
        }
    }
}

