/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;

public final class OpenApiJsonSchemaMapper
implements JsonSchemaMapper {
    private static final Set<String> UNSUPPORTED_KEYWORD_DIRECTIVES = SetUtils.of((Object[])new String[]{"propertyNames", "contentMediaType"});

    public Schema.Builder updateSchema(Shape shape, Schema.Builder builder, JsonSchemaConfig config) {
        boolean useOpenApiIntegerType;
        OpenApiJsonSchemaMapper.getResolvedExternalDocs(shape, config).map(Component::toNode).ifPresent(docs -> builder.putExtension("externalDocs", (ToNode)docs));
        if (shape.hasTrait(DeprecatedTrait.class)) {
            builder.putExtension("deprecated", (ToNode)Node.from((boolean)true));
        }
        boolean bl = useOpenApiIntegerType = config instanceof OpenApiConfig && ((OpenApiConfig)config).getUseIntegerType();
        if (!builder.getFormat().isPresent()) {
            if (useOpenApiIntegerType && shape.isIntegerShape()) {
                builder.format("int32");
            } else if (useOpenApiIntegerType && shape.isLongShape()) {
                builder.format("int64");
            } else if (shape.isFloatShape()) {
                this.updateFloatFormat(builder, config, "float");
            } else if (shape.isDoubleShape()) {
                this.updateFloatFormat(builder, config, "double");
            } else {
                if (shape.isBlobShape() && config instanceof OpenApiConfig) {
                    this.handleFormatKeyword(builder, (OpenApiConfig)config);
                    return builder;
                }
                if (shape.isTimestampShape()) {
                    config.detectJsonTimestampFormat(shape).filter(format -> format.equals("epoch-seconds")).ifPresent(format -> builder.format("double"));
                } else if (shape.hasTrait(SensitiveTrait.class)) {
                    builder.format("password");
                }
            }
        }
        UNSUPPORTED_KEYWORD_DIRECTIVES.forEach(arg_0 -> ((Schema.Builder)builder).disableProperty(arg_0));
        return builder;
    }

    private void handleFormatKeyword(Schema.Builder builder, OpenApiConfig config) {
        String blobFormat = config.getDefaultBlobFormat();
        if (config.getVersion().supportsContentEncodingKeyword()) {
            builder.contentEncoding(blobFormat);
        } else {
            builder.format(blobFormat);
        }
    }

    private void updateFloatFormat(Schema.Builder builder, JsonSchemaConfig config, String format) {
        if (config.getSupportNonNumericFloats()) {
            ArrayList<Schema> newOneOf = new ArrayList<Schema>();
            for (Schema schema : builder.build().getOneOf()) {
                if (schema.getType().isPresent() && ((String)schema.getType().get()).equals("number")) {
                    newOneOf.add(schema.toBuilder().format(format).build());
                    continue;
                }
                newOneOf.add(schema);
            }
            builder.oneOf(newOneOf);
        } else {
            builder.format(format);
        }
    }

    static Optional<ExternalDocumentation> getResolvedExternalDocs(Shape shape, JsonSchemaConfig config) {
        Optional traitOptional = shape.getTrait(ExternalDocumentationTrait.class);
        if (!traitOptional.isPresent() || !(config instanceof OpenApiConfig)) {
            return Optional.empty();
        }
        OpenApiConfig openApiConfig = (OpenApiConfig)config;
        ArrayList<String> externalDocKeys = new ArrayList<String>(openApiConfig.getExternalDocs().size());
        for (String key : openApiConfig.getExternalDocs()) {
            externalDocKeys.add(key.toLowerCase(Locale.ENGLISH));
        }
        Map traitUrls = ((ExternalDocumentationTrait)traitOptional.get()).getUrls();
        Map lowercaseKeyMap = (Map)traitUrls.keySet().stream().collect(MapUtils.toUnmodifiableMap(i -> i.toLowerCase(Locale.US), Function.identity()));
        for (String externalDocKey : externalDocKeys) {
            if (!lowercaseKeyMap.containsKey(externalDocKey)) continue;
            String traitKey = (String)lowercaseKeyMap.get(externalDocKey);
            return Optional.of(ExternalDocumentation.builder().description(traitKey).url((String)traitUrls.get(traitKey)).build());
        }
        return Optional.empty();
    }
}

