/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class InfoObject
extends Component
implements ToSmithyBuilder<InfoObject> {
    private final String title;
    private final String version;
    private final String description;
    private final String termsOfService;
    private final ObjectNode license;
    private final ObjectNode contact;

    private InfoObject(Builder builder) {
        super(builder);
        this.title = (String)SmithyBuilder.requiredState((String)"title", (Object)builder.title);
        this.version = (String)SmithyBuilder.requiredState((String)"version", (Object)builder.version);
        this.description = builder.description;
        this.termsOfService = builder.termsOfService;
        this.license = builder.license;
        this.contact = builder.contact;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getTermsOfService() {
        return Optional.ofNullable(this.termsOfService);
    }

    public Optional<ObjectNode> getLicense() {
        return Optional.ofNullable(this.license);
    }

    public Optional<ObjectNode> getContact() {
        return Optional.ofNullable(this.contact);
    }

    public Builder toBuilder() {
        return ((Builder)InfoObject.builder().extensions(this.getExtensions())).title(this.title).version(this.version).description(this.description).termsOfService(this.termsOfService).license(this.license).contact(this.contact);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        return Node.objectNodeBuilder().withMember("title", this.getTitle()).withMember("version", this.getVersion()).withOptionalMember("termsOfService", this.getTermsOfService().map(Node::from)).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("license", this.getLicense()).withOptionalMember("contact", this.getContact());
    }

    public static final class Builder
    extends Component.Builder<Builder, InfoObject> {
        private String title;
        private String version;
        private String description;
        private String termsOfService;
        private ObjectNode license;
        private ObjectNode contact;

        private Builder() {
        }

        public InfoObject build() {
            return new InfoObject(this);
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder termsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
            return this;
        }

        public Builder license(ObjectNode license) {
            this.license = license;
            return this;
        }

        public Builder contact(ObjectNode contact) {
            this.contact = contact;
            return this;
        }
    }
}

