/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ServerObject;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class LinkObject
extends Component
implements ToSmithyBuilder<LinkObject> {
    private final Map<String, Node> parameters = new TreeMap<String, Node>();
    private final String operationRef;
    private final String operationId;
    private final Node requestBody;
    private final String description;
    private final ServerObject server;

    private LinkObject(Builder builder) {
        super(builder);
        this.parameters.putAll(builder.parameters);
        this.operationId = builder.operationId;
        this.operationRef = builder.operationRef;
        this.requestBody = builder.requestBody;
        this.description = builder.description;
        this.server = builder.server;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Node> getParameters() {
        return this.parameters;
    }

    public Optional<String> getOperationRef() {
        return Optional.ofNullable(this.operationRef);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(this.operationId);
    }

    public Optional<Node> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<ServerObject> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("operationRef", this.getOperationRef().map(Node::from)).withOptionalMember("operationId", this.getOperationId().map(Node::from)).withOptionalMember("requestBody", this.getRequestBody()).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("server", this.getServer());
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)this.parameters.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)LinkObject.builder().extensions(this.getExtensions())).parameters(this.parameters).operationId(this.operationId).operationRef(this.operationRef).requestBody(this.requestBody).description(this.description).server(this.server);
    }

    public static final class Builder
    extends Component.Builder<Builder, LinkObject> {
        private final Map<String, Node> parameters = new TreeMap<String, Node>();
        private String operationRef;
        private String operationId;
        private Node requestBody;
        private String description;
        private ServerObject server;

        private Builder() {
        }

        public LinkObject build() {
            return new LinkObject(this);
        }

        public Builder operationRef(String operationRef) {
            this.operationRef = operationRef;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder parameters(Map<String, Node> parameters) {
            this.parameters.clear();
            this.parameters.putAll(parameters);
            return this;
        }

        public Builder requestBody(Node requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder server(ServerObject server) {
            this.server = server;
            return this;
        }
    }
}

