/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.security;

import java.util.Set;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class HttpApiKeyAuthConverter
implements SecuritySchemeConverter<HttpApiKeyAuthTrait> {
    @Override
    public Class<HttpApiKeyAuthTrait> getAuthSchemeType() {
        return HttpApiKeyAuthTrait.class;
    }

    @Override
    public SecurityScheme createSecurityScheme(Context<? extends Trait> context, HttpApiKeyAuthTrait trait) {
        return SecurityScheme.builder().type("apiKey").name(trait.getName()).in(trait.getIn().toString()).description("X-Api-Key authentication").build();
    }

    @Override
    public Set<String> getAuthRequestHeaders(Context<? extends Trait> context, HttpApiKeyAuthTrait trait) {
        return SetUtils.of((Object)trait.getName());
    }
}

