/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.AuthIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.fromsmithy.Smithy2OpenApiExtension;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.openapi.model.InfoObject;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.openapi.model.TagObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.Tagged;

public final class OpenApiConverter {
    private static final Logger LOGGER = Logger.getLogger(OpenApiConverter.class.getName());
    private Map<String, Node> settings = new HashMap<String, Node>();
    private ClassLoader classLoader = OpenApiConverter.class.getClassLoader();
    private JsonSchemaConverter jsonSchemaConverter;
    private String protocolName;
    private final List<OpenApiMapper> mappers = new ArrayList<OpenApiMapper>();

    private OpenApiConverter() {
    }

    public static OpenApiConverter create() {
        return new OpenApiConverter();
    }

    public OpenApiConverter jsonSchemaConverter(JsonSchemaConverter jsonSchemaConverter) {
        this.jsonSchemaConverter = jsonSchemaConverter;
        return this;
    }

    public OpenApiConverter addOpenApiMapper(OpenApiMapper mapper) {
        this.mappers.add(mapper);
        return this;
    }

    public <T extends ToNode> OpenApiConverter putSetting(String setting, T value) {
        this.settings.put(setting, value.toNode());
        return this;
    }

    public OpenApiConverter putSetting(String setting, String value) {
        this.settings.put(setting, (Node)Node.from((String)value));
        return this;
    }

    public OpenApiConverter putSetting(String setting, Number value) {
        this.settings.put(setting, (Node)Node.from((Number)value));
        return this;
    }

    public OpenApiConverter putSetting(String setting, boolean value) {
        this.settings.put(setting, (Node)Node.from((boolean)value));
        return this;
    }

    public OpenApiConverter classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public OpenApiConverter protocolName(String protocolName) {
        this.protocolName = protocolName;
        return this;
    }

    public OpenApi convert(Model model, ShapeId serviceShapeId) {
        return this.convertWithEnvironment(this.createConversionEnvironment(model, serviceShapeId));
    }

    public ObjectNode convertToNode(Model model, ShapeId serviceShapeId) {
        ConversionEnvironment environment = this.createConversionEnvironment(model, serviceShapeId);
        OpenApi openApi = this.convertWithEnvironment(environment);
        ObjectNode node = openApi.toNode().expectObjectNode();
        return environment.mapper.updateNode(environment.context, openApi, node);
    }

    private ConversionEnvironment createConversionEnvironment(Model model, ShapeId serviceShapeId) {
        ObjectNode.Builder configBuilder = this.getJsonSchemaConverter().getConfig().toBuilder().withMember("openapi.mode", true).withMember("definitionPointer", "#/components/schemas");
        ServiceShape service = (ServiceShape)((Shape)model.getShape(serviceShapeId).orElseThrow(() -> new IllegalArgumentException(String.format("Shape `%s` not found in shape index", serviceShapeId)))).asServiceShape().orElseThrow(() -> new IllegalArgumentException(String.format("Shape `%s` is not a service shape", serviceShapeId)));
        this.settings.forEach((arg_0, arg_1) -> ((ObjectNode.Builder)configBuilder).withMember(arg_0, arg_1));
        ObjectNode config = configBuilder.build();
        if (this.protocolName == null && config.getMember("protocol").isPresent()) {
            this.protocolName = ((StringNode)config.getStringMember("protocol").get()).getValue();
        }
        ArrayList<Smithy2OpenApiExtension> extensions = new ArrayList<Smithy2OpenApiExtension>();
        ServiceLoader.load(Smithy2OpenApiExtension.class, this.classLoader).forEach(extensions::add);
        extensions.forEach(extension -> extension.getJsonSchemaMappers().forEach(arg_0 -> ((JsonSchemaConverter)this.jsonSchemaConverter).addMapper(arg_0)));
        Pair<Protocol, OpenApiProtocol> protocolPair = this.resolveProtocol(service, extensions);
        Protocol resolvedProtocol = (Protocol)protocolPair.getLeft();
        OpenApiProtocol openApiProtocol = (OpenApiProtocol)protocolPair.getRight();
        LOGGER.info(() -> "Resolved " + resolvedProtocol.getName() + " OpenAPI protocol");
        for (Map.Entry entry : openApiProtocol.getDefaultSettings().getStringMap().entrySet()) {
            if (config.getMember((String)entry.getKey()).isPresent()) continue;
            config = config.withMember((String)entry.getKey(), (ToNode)((Node)entry.getValue()));
        }
        this.getJsonSchemaConverter().config(config);
        this.protocolName = this.protocolName != null ? this.protocolName : resolvedProtocol.getName();
        ComponentsObject.Builder components = ComponentsObject.builder();
        SchemaDocument schemas = this.addSchemas(components, model, service);
        List<SecuritySchemeConverter> securitySchemeConverters = this.loadSecuritySchemes(service, extensions);
        Context context = new Context(model, service, this.getJsonSchemaConverter(), resolvedProtocol, openApiProtocol, schemas, securitySchemeConverters);
        return new ConversionEnvironment(context, extensions, components, this.mappers);
    }

    private OpenApi convertWithEnvironment(ConversionEnvironment environment) {
        ServiceShape service = environment.context.getService();
        Context context = environment.context;
        OpenApiMapper mapper = environment.mapper;
        OpenApiProtocol openApiProtocol = environment.context.getOpenApiProtocol();
        OpenApi.Builder openapi = OpenApi.builder().openapi("3.0.2").info(this.createInfo(service));
        mapper.before(context, openapi);
        service.getTrait(ExternalDocumentationTrait.class).ifPresent(trait -> openapi.externalDocs(ExternalDocumentation.builder().url(trait.getValue()).build()));
        if (environment.context.getConfig().getBooleanMemberOrDefault("openapi.tags")) {
            this.getSupportedTags((Tagged)service).forEach(tag -> openapi.addTag(TagObject.builder().name((String)tag).build()));
        }
        this.addPaths(context, openapi, openApiProtocol, mapper);
        this.addSecurityComponents(context, openapi, environment.components, mapper);
        openapi.components(environment.components.build());
        context.getConfig().getObjectMember("schemaDocumentExtensions").ifPresent(openapi::extensions);
        return mapper.after(context, openapi.build());
    }

    private JsonSchemaConverter getJsonSchemaConverter() {
        if (this.jsonSchemaConverter == null) {
            this.jsonSchemaConverter = JsonSchemaConverter.create();
        }
        return this.jsonSchemaConverter;
    }

    private Pair<Protocol, OpenApiProtocol> resolveProtocol(ServiceShape service, List<Smithy2OpenApiExtension> extensions) {
        Optional<OpenApiProtocol> maybeProtocol;
        List<OpenApiProtocol> protocols = extensions.stream().flatMap(extension -> extension.getProtocols().stream()).collect(Collectors.toList());
        ProtocolsTrait protoTrait = (ProtocolsTrait)service.getTrait(ProtocolsTrait.class).orElseThrow(() -> new OpenApiException("No `protocols` trait found on `" + service.getId() + "`"));
        if (this.protocolName == null) {
            for (Protocol protocolEntry : protoTrait.getProtocols()) {
                Optional<OpenApiProtocol> maybeProtocol2 = this.findProtocol(protocolEntry.getName(), protocols);
                if (!maybeProtocol2.isPresent()) continue;
                return Pair.of((Object)protocolEntry, (Object)maybeProtocol2.get());
            }
        } else if (protoTrait.getProtocol(this.protocolName).isPresent() && (maybeProtocol = this.findProtocol(this.protocolName, protocols)).isPresent()) {
            return Pair.of((Object)((Protocol)protoTrait.getProtocol(this.protocolName).get()), (Object)maybeProtocol.get());
        }
        throw new OpenApiException(String.format("Unable to resolve a supported protocol for service: `%s`. Protocol service providers were found for the following protocols: [%s]. But this service supports the following protocols: [%s]", service.getId(), ValidationUtils.tickedList(protocols.stream().flatMap(p -> p.getProtocolNames().stream())), ValidationUtils.tickedList((Collection)protoTrait.getProtocolNames())));
    }

    private Optional<OpenApiProtocol> findProtocol(String protocolName, List<OpenApiProtocol> protocols) {
        return protocols.stream().filter(protocol -> protocol.getProtocolNames().contains(protocolName)).findFirst();
    }

    private List<SecuritySchemeConverter> loadSecuritySchemes(ServiceShape service, List<Smithy2OpenApiExtension> extensions) {
        List converters = extensions.stream().flatMap(extension -> extension.getSecuritySchemeConverters().stream()).collect(Collectors.toList());
        HashSet schemes = new HashSet(service.getTrait(ProtocolsTrait.class).flatMap(trait -> trait.getProtocol(this.protocolName)).map(Protocol::getAuth).orElse(ListUtils.of()));
        ArrayList<SecuritySchemeConverter> resolved = new ArrayList<SecuritySchemeConverter>();
        for (SecuritySchemeConverter converter : converters) {
            if (!schemes.remove(converter.getAuthSchemeName())) continue;
            resolved.add(converter);
        }
        if (!schemes.isEmpty()) {
            LOGGER.warning(() -> String.format("Unable to find an OpenAPI authentication converter for the following schemes: [%s]", schemes));
        }
        return resolved;
    }

    private Stream<String> getSupportedTags(Tagged tagged) {
        ObjectNode config = this.getJsonSchemaConverter().getConfig();
        List supported = config.getArrayMember("openapi.supportedTags").map(array -> array.getElementsAs(StringNode::getValue)).orElse(null);
        return tagged.getTags().stream().filter(tag -> supported == null || supported.contains(tag));
    }

    private InfoObject createInfo(ServiceShape service) {
        InfoObject.Builder infoBuilder = InfoObject.builder();
        service.getTrait(DocumentationTrait.class).ifPresent(trait -> infoBuilder.description(trait.getValue()));
        infoBuilder.version(service.getVersion());
        infoBuilder.title(service.getTrait(TitleTrait.class).map(StringTrait::getValue).orElse(service.getId().getName()));
        return infoBuilder.build();
    }

    private SchemaDocument addSchemas(ComponentsObject.Builder components, Model model, ServiceShape service) {
        SchemaDocument document = this.getJsonSchemaConverter().convert(model, (Shape)service);
        for (Map.Entry entry : document.getDefinitions().entrySet()) {
            String key = ((String)entry.getKey()).replace("#/components/schemas/", "");
            components.putSchema(key, (Schema)entry.getValue());
        }
        return document;
    }

    private void addPaths(Context context, OpenApi.Builder openApiBuilder, OpenApiProtocol protocolService, OpenApiMapper plugin) {
        TopDownIndex topDownIndex = (TopDownIndex)context.getModel().getKnowledge(TopDownIndex.class);
        HashMap paths = new HashMap();
        topDownIndex.getContainedOperations((ToShapeId)context.getService()).forEach(shape -> OptionalUtils.ifPresentOrElse(protocolService.createOperation(context, (OperationShape)shape), result -> {
            PathItem.Builder pathItem = paths.computeIfAbsent(result.getUri(), uri -> PathItem.builder());
            this.addOperationSecurity(context, result.getOperation(), (OperationShape)shape, plugin);
            OperationObject builtOperation = plugin.updateOperation(context, (OperationShape)shape, result.getOperation().build());
            builtOperation = this.addOperationTags(context, (Shape)shape, builtOperation);
            builtOperation = this.updateParameters(context, (OperationShape)shape, builtOperation, plugin);
            builtOperation = this.updateResponses(context, (OperationShape)shape, builtOperation, plugin);
            builtOperation = this.updateRequestBody(context, (OperationShape)shape, builtOperation, plugin);
            switch (result.getMethod().toLowerCase(Locale.US)) {
                case "get": {
                    pathItem.get(builtOperation);
                    break;
                }
                case "put": {
                    pathItem.put(builtOperation);
                    break;
                }
                case "delete": {
                    pathItem.delete(builtOperation);
                    break;
                }
                case "post": {
                    pathItem.post(builtOperation);
                    break;
                }
                case "patch": {
                    pathItem.patch(builtOperation);
                    break;
                }
                case "head": {
                    pathItem.head(builtOperation);
                    break;
                }
                case "trace": {
                    pathItem.trace(builtOperation);
                    break;
                }
                case "options": {
                    pathItem.options(builtOperation);
                    break;
                }
                default: {
                    LOGGER.warning(String.format("The %s HTTP method of `%s` is not supported by OpenAPI", result.getMethod(), shape.getId()));
                }
            }
        }, () -> LOGGER.warning(String.format("The `%s` operation is not supported by the `%s` protocol (implemented by `%s`), and was omitted", shape.getId(), protocolService.getClass().getName(), context.getProtocolName()))));
        for (Map.Entry entry : paths.entrySet()) {
            String pathName = (String)entry.getKey();
            PathItem pathItem = plugin.updatePathItem(context, pathName, ((PathItem.Builder)entry.getValue()).build());
            openApiBuilder.putPath(pathName, pathItem);
        }
    }

    private void addOperationSecurity(Context context, OperationObject.Builder builder, OperationShape shape, OpenApiMapper plugin) {
        ServiceShape service = context.getService();
        AuthIndex auth = (AuthIndex)context.getModel().getKnowledge(AuthIndex.class);
        List serviceSchemes = auth.getDefaultServiceSchemes((ToShapeId)service);
        List operationSchemes = auth.getOperationSchemes((ToShapeId)service, (ToShapeId)shape, context.getProtocolName());
        if (!SetUtils.copyOf((Collection)serviceSchemes).equals(SetUtils.copyOf((Collection)operationSchemes))) {
            for (SecuritySchemeConverter converter : this.findMatchingConverters(context, operationSchemes)) {
                List<String> result = converter.createSecurityRequirements(context, (Shape)context.getService());
                Map<String, List<String>> requirement = plugin.updateSecurity(context, (Shape)shape, converter, MapUtils.of((Object)converter.getAuthSchemeName(), result));
                if (requirement == null) continue;
                builder.addSecurity(requirement);
            }
        }
    }

    private OperationObject addOperationTags(Context context, Shape shape, OperationObject operation) {
        List<String> tags;
        if (context.getConfig().getBooleanMemberOrDefault("openapi.tags") && !(tags = this.getSupportedTags((Tagged)shape).collect(Collectors.toList())).isEmpty()) {
            return operation.toBuilder().tags(tags).build();
        }
        return operation;
    }

    private OperationObject updateParameters(Context context, OperationShape shape, OperationObject operation, OpenApiMapper plugin) {
        ArrayList<ParameterObject> parameters = new ArrayList<ParameterObject>();
        for (ParameterObject parameter : operation.getParameters()) {
            parameters.add(plugin.updateParameter(context, shape, parameter));
        }
        return !parameters.equals(operation.getParameters()) ? operation.toBuilder().parameters(parameters).build() : operation;
    }

    private OperationObject updateRequestBody(Context context, OperationShape shape, OperationObject operation, OpenApiMapper plugin) {
        return operation.getRequestBody().map(body -> {
            RequestBodyObject updatedBody = plugin.updateRequestBody(context, shape, (RequestBodyObject)body);
            return body.equals(updatedBody) ? operation : operation.toBuilder().requestBody(updatedBody).build();
        }).orElse(operation);
    }

    private OperationObject updateResponses(Context context, OperationShape shape, OperationObject operation, OpenApiMapper plugin) {
        LinkedHashMap<String, ResponseObject> newResponses = new LinkedHashMap<String, ResponseObject>();
        Map originalResponses = operation.getResponses();
        if (operation.getResponses().isEmpty()) {
            String code = context.getOpenApiProtocol().getOperationResponseStatusCode(context, (ToShapeId)shape);
            originalResponses = MapUtils.of((Object)code, (Object)ResponseObject.builder().description(shape.getId().getName() + " response").build());
        }
        for (Map.Entry<String, ResponseObject> entry : originalResponses.entrySet()) {
            String status = entry.getKey();
            ResponseObject responseObject = plugin.updateResponse(context, status, shape, entry.getValue());
            newResponses.put(status, responseObject);
        }
        return !newResponses.equals(operation.getResponses()) ? operation.toBuilder().responses(newResponses).build() : operation;
    }

    private void addSecurityComponents(Context context, OpenApi.Builder openApiBuilder, ComponentsObject.Builder components, OpenApiMapper plugin) {
        OptionalUtils.ifPresentOrElse((Optional)context.getService().getTrait(ProtocolsTrait.class), trait -> {
            for (SecuritySchemeConverter converter : context.getSecuritySchemeConverters()) {
                SecurityScheme createdScheme;
                String authName = converter.getAuthSchemeName();
                SecurityScheme scheme = plugin.updateSecurityScheme(context, authName, createdScheme = converter.createSecurityScheme(context));
                if (scheme == null) continue;
                components.putSecurityScheme(authName, scheme);
            }
        }, () -> LOGGER.warning("No `protocols` trait found on service while converting to OpenAPI"));
        AuthIndex authIndex = (AuthIndex)context.getModel().getKnowledge(AuthIndex.class);
        List schemes = authIndex.getDefaultServiceSchemes((ToShapeId)context.getService());
        for (SecuritySchemeConverter converter : this.findMatchingConverters(context, schemes)) {
            List<String> result = converter.createSecurityRequirements(context, (Shape)context.getService());
            Map<String, List<String>> requirement = plugin.updateSecurity(context, (Shape)context.getService(), converter, MapUtils.of((Object)converter.getAuthSchemeName(), result));
            if (requirement == null) continue;
            openApiBuilder.addSecurity(requirement);
        }
    }

    private Collection<SecuritySchemeConverter> findMatchingConverters(Context context, Collection<String> schemes) {
        return context.getSecuritySchemeConverters().stream().filter(converter -> schemes.contains(converter.getAuthSchemeName())).collect(Collectors.toList());
    }

    private static final class ConversionEnvironment {
        private final Context context;
        private final List<Smithy2OpenApiExtension> extensions;
        private final ComponentsObject.Builder components;
        private final OpenApiMapper mapper;

        private ConversionEnvironment(Context context, List<Smithy2OpenApiExtension> extensions, ComponentsObject.Builder components, List<OpenApiMapper> mappers) {
            this.context = context;
            this.extensions = extensions;
            this.components = components;
            this.mapper = this.createMapper(mappers);
        }

        private OpenApiMapper createMapper(List<OpenApiMapper> mappers) {
            return OpenApiMapper.compose(Stream.concat(this.extensions.stream().flatMap(extension -> extension.getOpenApiMappers().stream()), mappers.stream()).collect(Collectors.toList()));
        }
    }
}

