/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.protocols.AbstractRestProtocol;
import software.amazon.smithy.utils.SetUtils;

public final class AwsRestJsonProtocol
extends AbstractRestProtocol {
    @Override
    public Set<String> getProtocolNames() {
        return SetUtils.of((Object[])new String[]{"aws.rest-json", "aws.rest-json-1.0", "aws.rest-json-1.1"});
    }

    @Override
    public ObjectNode getDefaultSettings() {
        return Node.objectNode().withMember("useJsonName", true);
    }

    @Override
    String getDocumentMediaType(Context context, Shape operationOrError, AbstractRestProtocol.MessageType message) {
        return context.getConfig().getStringMemberOrDefault("openapi.aws.jsonContentType", "application/json");
    }

    @Override
    Schema createDocumentSchema(Context context, Shape operationOrError, List<HttpBinding> bindings, AbstractRestProtocol.MessageType message) {
        if (bindings.isEmpty()) {
            return Schema.builder().type("object").build();
        }
        ShapeId container = bindings.get(0).getMember().getContainer();
        StructureShape.Builder tempShapeBuilder = (StructureShape.Builder)StructureShape.builder().id(container);
        for (HttpBinding binding : bindings) {
            tempShapeBuilder.addMember(((MemberShape.Builder)binding.getMember().toBuilder().id(container.withMember(binding.getMemberName()))).build());
        }
        StructureShape tempShape = tempShapeBuilder.build();
        ShapeIndex index = context.getModel().getShapeIndex();
        return context.getJsonSchemaConverter().convert(index, (Shape)tempShape).getRootSchema();
    }
}

